/**
 *	Copyright (c) 2015 Vör Security Inc.
 *	All rights reserved.
 *	
 *	Redistribution and use in source and binary forms, with or without
 *	modification, are permitted provided that the following conditions are met:
 *	    * Redistributions of source code must retain the above copyright
 *	      notice, this list of conditions and the following disclaimer.
 *	    * Redistributions in binary form must reproduce the above copyright
 *	      notice, this list of conditions and the following disclaimer in the
 *	      documentation and/or other materials provided with the distribution.
 *	    * Neither the name of the <organization> nor the
 *	      names of its contributors may be used to endorse or promote products
 *	      derived from this software without specific prior written permission.
 *	
 *	THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS" AND
 *	ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 *	WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 *	DISCLAIMED. IN NO EVENT SHALL <COPYRIGHT HOLDER> BE LIABLE FOR ANY
 *	DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 *	(INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 *	LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 *	ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 *	(INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS
 *	SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 */
package net.ossindex.common;

/** Load on the server is reduced by caching data wherever possible. This
 * interface allows for multiple cache implementations, depending on the use case.
 * 
 * @author Ken Duck
 *
 */
public interface IOssIndexCache
{

	/** Cache the specified query
	 * 
	 * @param requestString Request that is being cached
	 * @param json Response to request
	 */
	void cache(String requestString, String json);

	/** Get cached results, if they are available
	 * 
	 * @param requestString Request that was cached
	 * @return Response to request
	 */
	String get(String requestString);

	/** Return the cached value if the elapsed time is not passed.
	 * 
	 * A delay of &lt; 0 indicates that we should just use the cached value
	 * 
	 * @param requestString Request that is being cached
	 * @param delay Elapsed time before we ignore the cached value
	 * @return Response to request
	 */
	String get(String requestString, long delay);
	
	/**
	 * Commit any recent changes into the cache
	 */
	void commit();
	
	/**
	 * Ensure that the cache persists if required
	 */
	void close();

	/** Clear the cache
	 * 
	 */
	void clear();
}
