/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.resource;

import java.net.URI;
import java.net.URISyntaxException;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.version.IVersion;
import net.ossindex.version.VersionFactory;
import net.ossindex.version.VersionRange;

public class VulnerabilityResource
extends AbstractRemoteResource {
    private String complexity;
    private String vector;
    private String authentication;
    private String availability;
    private String confidentiality;
    private String integrity;
    private String source;
    private String security_protection;
    private Long discovered;
    private Long generated;
    private Long published;
    private Long modified;
    private String cveId;
    private String uri;
    private String title;
    private String summary;
    private String details;
    private String[] versions;

    @Override
    protected String getResourceType() {
        return "vulnerability";
    }

    public boolean isCve() {
        return this.getId() > 0L;
    }

    public URI getUri() {
        if (this.uri != null) {
            try {
                return new URI(this.uri);
            }
            catch (URISyntaxException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    public String[] getVersions() {
        return this.versions;
    }

    public String getDescription() {
        if (this.summary != null) {
            return this.summary;
        }
        return this.uri.toString();
    }

    public String getTitle() {
        if (this.title != null) {
            return this.title;
        }
        return this.uri.toString();
    }

    public boolean affects(String name, String range) {
        if (this.versions != null) {
            VersionRange myRange = new VersionRange(this.versions);
            VersionRange yourRange = new VersionRange(range);
            return myRange.intersects(yourRange);
        }
        return false;
    }

    public boolean appliesTo(String version) {
        IVersion suppliedVersion = VersionFactory.getVersionFactory().getVersion(version);
        for (String v : this.versions) {
            IVersion hv = VersionFactory.getVersionFactory().getVersion(v);
            if (hv.satisfies(version)) {
                return true;
            }
            if (suppliedVersion == null || !suppliedVersion.satisfies(v)) continue;
            boolean filter = false;
            if (!version.equals(v) && version.startsWith(v)) {
                filter = true;
            }
            if (filter) continue;
            return true;
        }
        return false;
    }
}

