/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.resource;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.ossindex.common.ResourceFactory;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.common.resource.VulnerabilityResource;

public class ScmResource
extends AbstractRemoteResource {
    private String uri;
    private String name;
    private String description;
    private long size;
    private String scm_type;
    private String requires;
    private boolean hasVulnerability;
    private String vulnerabilities;
    private String references;
    private String releases;
    private String files;
    private String authors;
    private String languages;
    private VulnerabilityResource[] vulnerabilityCache;

    @Override
    protected String getResourceType() {
        return "scm";
    }

    public VulnerabilityResource[] getVulnerabilities() throws IOException {
        if (this.vulnerabilityCache != null) {
            return this.vulnerabilityCache;
        }
        if (!this.hasVulnerability) {
            this.vulnerabilityCache = new VulnerabilityResource[0];
        } else {
            TypeToken<ArrayList<VulnerabilityResource>> type = new TypeToken<ArrayList<VulnerabilityResource>>(){};
            List<VulnerabilityResource> results = ResourceFactory.getResourceFactory().getResources(type, "/v1.0/scm/" + this.getId() + "/vulnerabilities");
            this.vulnerabilityCache = results.toArray(new VulnerabilityResource[results.size()]);
        }
        return this.vulnerabilityCache;
    }

    public String getName() {
        return this.name;
    }

    public String toString() {
        if (this.uri == null) {
            return this.name;
        }
        return this.uri.toString();
    }

    public String getDescription() {
        return this.description;
    }
}

