/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.cache;

import java.io.File;
import java.util.concurrent.ConcurrentNavigableMap;
import net.ossindex.common.IOssIndexCache;
import org.mapdb.DB;
import org.mapdb.DBMaker;

public class MapDbCache
implements IOssIndexCache {
    private DB db;
    private ConcurrentNavigableMap<String, String> map;

    public MapDbCache(File root) {
        this.db = DBMaker.fileDB((File)new File(root, "ossindex.cache")).closeOnJvmShutdown().make();
        this.map = this.db.treeMap("queryCache");
    }

    @Override
    public void cache(String requestString, String json) {
        this.map.put(requestString, "(T=" + System.currentTimeMillis() + ")" + json);
    }

    @Override
    public String get(String requestString) {
        String buf = (String)this.map.get(requestString);
        if (buf != null && buf.startsWith("(T=")) {
            int index = buf.indexOf(41);
            buf = buf.substring(index + 1);
        }
        return buf;
    }

    @Override
    public String get(String requestString, long delay) {
        if (delay > 0L) {
            String buf = (String)this.map.get(requestString);
            if (buf != null) {
                if (buf.startsWith("(T=")) {
                    buf = buf.substring(3);
                    int index = buf.indexOf(41);
                    long timestamp = Long.parseLong(buf.substring(0, index));
                    buf = buf.substring(index + 1);
                    long now = System.currentTimeMillis();
                    if (now - timestamp < delay) {
                        return buf;
                    }
                } else {
                    return null;
                }
            }
            return null;
        }
        return this.get(requestString);
    }

    @Override
    public void commit() {
        this.db.commit();
    }

    @Override
    public void close() {
        this.db.commit();
        this.db.close();
    }
}

