/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.resource;

import com.google.gson.reflect.TypeToken;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ossindex.common.ResourceFactory;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.common.resource.PackageResource;
import net.ossindex.version.IVersion;
import net.ossindex.version.VersionFactory;

public class ArtifactResource
extends AbstractRemoteResource
implements Comparable<ArtifactResource> {
    private String name;
    private String version;
    private String description;
    private String package_manager;
    private String scm;
    private long scm_id;
    private long package_id;
    private String url;
    private String details;
    private String dependencies;
    private String[] search;
    private static final Pattern packagePattern3 = Pattern.compile("^(.*)-[0-9]+\\.[0-9]+\\.[0-9]+");
    private static final Pattern packagePattern2 = Pattern.compile("^(.*)-[0-9]+\\.[0-9]+");

    ArtifactResource() {
    }

    public ArtifactResource(long id) {
        super(id);
    }

    @Override
    protected String getResourceType() {
        return "artifact";
    }

    public String getName() {
        return this.name;
    }

    public String getPackageName() {
        int index;
        if (this.version != null && (index = this.name.lastIndexOf(this.version)) > 0) {
            String result = this.name.substring(0, index);
            while (result.endsWith("-")) {
                result = result.substring(0, result.length() - 1);
            }
            return result;
        }
        Matcher m = packagePattern3.matcher(this.name);
        if (m.find()) {
            return m.group(1);
        }
        m = packagePattern2.matcher(this.name);
        if (m.find()) {
            return m.group(1);
        }
        return this.name;
    }

    public String getVersionString() {
        return this.version;
    }

    public String getDescription() {
        return this.description;
    }

    public String getPackageManager() {
        return this.package_manager;
    }

    public String[] getSearch() {
        return this.search;
    }

    public long getScmId() {
        return this.scm_id;
    }

    public IVersion getVersion() {
        return VersionFactory.getVersionFactory().getVersion(this.package_manager, this.version);
    }

    @Override
    public int compareTo(ArtifactResource res) {
        if (res == null) {
            return 1;
        }
        IVersion myVersion = this.getVersion();
        IVersion yourVersion = res.getVersion();
        if (yourVersion == null) {
            return 1;
        }
        if (myVersion == null) {
            return -1;
        }
        return myVersion.compareTo((Object)yourVersion);
    }

    public PackageResource getPackage() throws IOException {
        if (this.package_id > 0L) {
            return ResourceFactory.getResourceFactory().createResource(PackageResource.class, this.package_id);
        }
        return null;
    }

    public ArtifactResource[] getDependencyGraph() {
        try {
            TypeToken<ArrayList<ArtifactResource>> type = new TypeToken<ArrayList<ArtifactResource>>(){};
            List<ArtifactResource> results = ResourceFactory.getResourceFactory().getResources(type, "/v1.0/artifact/" + this.getId() + "/dependency_graph");
            if (results != null) {
                AbstractRemoteResource[] resources = results.toArray(new ArtifactResource[results.size()]);
                ResourceFactory.getResourceFactory().cacheResources(resources);
                return resources;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }
}

