/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common.utils;

import java.io.IOException;
import net.ossindex.common.resource.ArtifactResource;
import net.ossindex.common.resource.ScmResource;
import net.ossindex.common.resource.VulnerabilityResource;
import net.ossindex.common.utils.FilePosition;

public class PackageDependency {
    private String pkgManager;
    private String name;
    private String groupId;
    private String version;
    private ArtifactResource artifact;
    private ScmResource scm;
    private FilePosition position;
    private boolean optional = false;
    private boolean isRoot;

    public PackageDependency(FilePosition position, String pkgManager, String pkgName, String version) {
        this.position = position;
        this.name = pkgName;
        this.version = version;
        this.pkgManager = pkgManager;
    }

    public PackageDependency(String pkgManager, String pkgName, String version) {
        this.name = pkgName;
        this.version = version;
        this.pkgManager = pkgManager;
    }

    public PackageDependency(String pkgManager, String groupId, String artifactId, String version) {
        this.groupId = groupId;
        this.name = artifactId;
        this.version = version;
        this.pkgManager = pkgManager;
    }

    public boolean equals(Object o) {
        if (o instanceof PackageDependency) {
            PackageDependency dep = (PackageDependency)o;
            return this.toString().equals(dep.toString());
        }
        return false;
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String getPackageManager() {
        return this.pkgManager;
    }

    public String getName() {
        return this.name;
    }

    public String getGroupId() {
        return this.groupId;
    }

    public String getVersion() {
        return this.version;
    }

    public int getLine() {
        if (this.position != null) {
            return this.position.getLine();
        }
        return 0;
    }

    public int getOffset() {
        if (this.position != null) {
            return this.position.getOffset();
        }
        return 0;
    }

    public int getLength() {
        if (this.position != null) {
            return this.position.getLength();
        }
        return 0;
    }

    public String toString() {
        return "[" + this.pkgManager + "] " + this.name + " " + this.version;
    }

    public void setArtifact(ArtifactResource artifact) {
        this.artifact = artifact;
    }

    public void setScm(ScmResource scmResource) {
        this.scm = scmResource;
    }

    public ArtifactResource getArtifact() {
        return this.artifact;
    }

    public ScmResource getScm() {
        return this.scm;
    }

    public String getDescription() {
        if (this.artifact != null) {
            return this.artifact.getDescription();
        }
        return "unknown";
    }

    public VulnerabilityResource[] getVulnerabilities() throws IOException {
        if (this.scm != null) {
            return this.scm.getVulnerabilities();
        }
        return new VulnerabilityResource[0];
    }

    public String getId() {
        return this.groupId + ":" + this.name + ":" + this.version;
    }

    public void setOptional(Boolean optional) {
        if (optional != null) {
            this.optional = optional;
        }
    }

    public boolean getOptional() {
        return this.optional;
    }

    public void setIsRoot(boolean b) {
        this.isRoot = b;
    }

    public boolean isRoot() {
        return this.isRoot;
    }
}

