/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.common;

import com.google.gson.Gson;
import com.google.gson.JsonSyntaxException;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.ConnectException;
import java.util.List;
import net.ossindex.common.IOssIndexCache;
import net.ossindex.common.resource.AbstractRemoteResource;
import net.ossindex.common.resource.ArtifactResource;
import net.ossindex.common.resource.FileResource;
import net.ossindex.common.resource.PackageResource;
import net.ossindex.common.resource.ScmResource;
import net.ossindex.common.utils.PackageDependency;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.BasicConfigurator;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;

public class ResourceFactory {
    private static final long ONE_MINUTE = 60000L;
    private static final long TEN_MINUTES = 600000L;
    private static final long ONE_HOUR = 3600000L;
    private static final long ONE_DAY = 86400000L;
    private static ResourceFactory instance;
    private IOssIndexCache cache;
    private static boolean DEBUG;
    private static long timeout;
    private static String scheme;
    private static String host;
    private static int port;

    private ResourceFactory() {
    }

    public static synchronized ResourceFactory getResourceFactory() {
        if (instance == null) {
            instance = new ResourceFactory();
        }
        return instance;
    }

    public void setCache(IOssIndexCache cache) {
        this.cache = cache;
    }

    public IOssIndexCache getCache() {
        return this.cache;
    }

    protected static String getBaseUrl() {
        if (port >= 0) {
            return scheme + "://" + host + ":" + port;
        }
        return scheme + "://" + host;
    }

    public static void setDebug(boolean b) {
        if (b) {
            scheme = "http";
            host = "localhost";
            port = 8080;
        } else {
            scheme = "https";
            host = "ossindex.net";
            port = -1;
        }
    }

    public ArtifactResource findArtifactResource(PackageDependency dep) throws IOException {
        ArtifactResource[] resources = this.findArtifactResources(new PackageDependency[]{dep});
        if (resources != null && resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    public ArtifactResource[] findArtifactResources(PackageDependency[] pkgDeps) throws IOException {
        if (pkgDeps == null || pkgDeps.length == 0) {
            return new ArtifactResource[0];
        }
        String reqPath = "/v1.0/search/artifact/";
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        for (int i = 0; i < pkgDeps.length; ++i) {
            PackageDependency dep = pkgDeps[i];
            if (i > 0) {
                sb.append(",");
            }
            sb.append("{");
            sb.append("\"pm\": \"" + dep.getPackageManager() + "\",");
            sb.append("\"name\": \"" + dep.getName() + "\",");
            if (dep.getGroupId() != null) {
                sb.append("\"group\": \"" + dep.getGroupId() + "\",");
            }
            sb.append("\"version\": \"" + dep.getVersion() + "\"");
            sb.append("}");
        }
        sb.append("]");
        if (DEBUG) {
            System.err.println("Request: " + reqPath + "...");
            System.err.println("  DATA: " + sb.toString());
        }
        String requestString = reqPath;
        String data = sb.toString();
        String json = this.doPost(requestString, data);
        Gson gson = new Gson();
        try {
            AbstractRemoteResource[] resources = (ArtifactResource[])gson.fromJson(json, ArtifactResource[].class);
            this.cacheResources(resources);
            return resources;
        }
        catch (JsonSyntaxException e) {
            System.err.println("Exception parsing response from request '" + reqPath + "'");
            System.err.println(json);
            throw new ConnectException(e.getMessage());
        }
    }

    public FileResource findFileResource(File file) throws IOException {
        FileResource[] resources = this.findFileResources(new File[]{file});
        if (resources != null && resources.length > 0) {
            return resources[0];
        }
        return null;
    }

    public FileResource[] findFileResources(File[] files) throws IOException {
        if (files == null || files.length == 0) {
            return new FileResource[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/v1.0/sha1/");
        for (int i = 0; i < files.length; ++i) {
            File file = files[i];
            if (i > 0) {
                sb.append(",");
            }
            String sha1 = ResourceFactory.getSha1(file);
            sb.append(sha1);
        }
        String requestString = sb.toString();
        if (DEBUG) {
            System.err.print("Request: " + requestString + "...");
        }
        String json = this.doGetArray(requestString);
        Gson gson = new Gson();
        try {
            AbstractRemoteResource[] resources = (FileResource[])gson.fromJson(json, FileResource[].class);
            this.cacheResources(resources);
            return resources;
        }
        catch (JsonSyntaxException e) {
            System.err.println("Exception parsing response from request '" + requestString + "'");
            System.err.println(json);
            throw new ConnectException(e.getMessage());
        }
    }

    private static String getSha1(File file) throws IOException {
        try (FileInputStream is = null;){
            is = new FileInputStream(file);
            String string = DigestUtils.shaHex((InputStream)is);
            return string;
        }
    }

    public ScmResource[] findScmResources(long[] scmIds) throws IOException {
        if (scmIds == null || scmIds.length == 0) {
            return new ScmResource[0];
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/v1.0/scm/");
        for (int i = 0; i < scmIds.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(scmIds[i]);
        }
        String requestString = sb.toString();
        String json = this.doGetArray(requestString);
        if (json != null) {
            Gson gson = new Gson();
            try {
                AbstractRemoteResource[] resources = (ScmResource[])gson.fromJson(json, ScmResource[].class);
                this.cacheResources(resources);
                return resources;
            }
            catch (JsonSyntaxException e) {
                System.err.println("Exception parsing response from request '" + requestString + "'");
                System.err.println(json);
                throw new ConnectException(e.getMessage());
            }
        }
        return null;
    }

    public <T extends AbstractRemoteResource> List<T> getResources(TypeToken<?> type, String query) throws IOException {
        List results = null;
        String requestString = query;
        String json = this.doGetArray(requestString);
        Gson gson = new Gson();
        try {
            results = (List)gson.fromJson(json, type.getType());
        }
        catch (JsonSyntaxException e) {
            System.err.println("Exception parsing response from request '" + requestString + "'");
            System.err.println(json);
            throw new ConnectException(e.getMessage());
        }
        return results;
    }

    public <T extends AbstractRemoteResource> T createResource(Class<T> cls, long id) throws IOException {
        String query = this.getResourceQuery(cls, id);
        if (query != null) {
            String json = this.doGet(query);
            if ((json = json.trim()).startsWith("[")) {
                json = json.substring(1, json.length() - 1);
                this.cache.cache(query, json);
            }
            Gson gson = new Gson();
            try {
                return (T)((AbstractRemoteResource)gson.fromJson(json, cls));
            }
            catch (JsonSyntaxException e) {
                System.err.println("Exception parsing response from request '" + query + "'");
                System.err.println(json);
                throw new ConnectException(e.getMessage());
            }
        }
        return null;
    }

    private String getResourceQuery(Class<? extends AbstractRemoteResource> cls, long id) {
        if (ArtifactResource.class.isAssignableFrom(cls)) {
            return "/v1.0/artifact/" + id;
        }
        if (PackageResource.class.isAssignableFrom(cls)) {
            return "/v1.0/package/" + id;
        }
        if (ScmResource.class.isAssignableFrom(cls)) {
            return "/v1.0/scm/" + id;
        }
        return null;
    }

    private String doGetArray(String requestString) throws IOException {
        String json = this.doGet(requestString);
        if (json != null && !(json = json.trim()).startsWith("[")) {
            json = "[" + json + "]";
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doGet(String requestString) throws IOException {
        String json = null;
        if (this.cache != null) {
            long delay = 86400000L;
            if (timeout > 0L) {
                long now = System.currentTimeMillis();
                if (now - timeout > 600000L) {
                    timeout = 0L;
                } else {
                    delay = -1L;
                }
            }
            json = this.cache.get(requestString, delay);
        }
        if (json == null) {
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                HttpGet request = new HttpGet(ResourceFactory.getBaseUrl() + requestString);
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int code = response.getStatusLine().getStatusCode();
                if (code >= 200 && code < 300) {
                    json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
                }
            }
            if (json != null && this.cache != null) {
                this.cache.cache(requestString, json);
            }
        }
        return json;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String doPost(String requestString, String data) throws IOException {
        String json = null;
        String cacheId = requestString + "::" + data;
        if (this.cache != null) {
            long delay = 86400000L;
            if (timeout > 0L) {
                long now = System.currentTimeMillis();
                if (now - timeout > 600000L) {
                    timeout = 0L;
                } else {
                    delay = -1L;
                }
            }
            json = this.cache.get(cacheId, delay);
        }
        if (json == null) {
            HttpPost request = new HttpPost(ResourceFactory.getBaseUrl() + requestString);
            request.setEntity((HttpEntity)new StringEntity(data));
            try (CloseableHttpClient httpClient = HttpClients.createDefault();){
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)request);
                int code = response.getStatusLine().getStatusCode();
                if (code < 200 || code > 299) {
                    throw new ConnectException(response.getStatusLine().getReasonPhrase() + " (" + code + ")");
                }
                json = EntityUtils.toString((HttpEntity)response.getEntity(), (String)"UTF-8");
            }
            if (json != null && this.cache != null) {
                this.cache.cache(cacheId, json);
            }
        }
        return json;
    }

    public <T extends AbstractRemoteResource> void cacheResources(T[] resources) {
        Gson gson = new Gson();
        if (resources != null && this.cache != null) {
            for (T t : resources) {
                long id = ((AbstractRemoteResource)t).getId();
                String query = this.getResourceQuery(t.getClass(), id);
                if (query == null) continue;
                String json = gson.toJson(t);
                this.cache.cache(query, json);
            }
        }
    }

    public void closeCache() {
        this.cache.close();
    }

    static {
        BasicConfigurator.configure();
        Logger.getRootLogger().setLevel(Level.WARN);
        DEBUG = false;
        timeout = 0L;
        scheme = "https";
        host = "ossindex.net";
        port = -1;
    }
}

