/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.expr.Expression;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.AbstractCommonRange;
import net.ossindex.version.impl.SemanticVersion;

public class BoundedVersionRange
extends AbstractCommonRange
implements IVersionRange {
    private String type;
    private Expression expression;
    private IVersion minimum;
    private IVersion maximum;
    private String range;
    private boolean hasErrors = false;

    public BoundedVersionRange(SemanticVersion version) {
        this.minimum = version;
    }

    public BoundedVersionRange(IVersion min, IVersion max) {
        this.minimum = min;
        this.maximum = max;
        this.range = ">=" + min + " <=" + max;
    }

    @Override
    public boolean contains(IVersion version) {
        if (version instanceof SemanticVersion) {
            return this.expression.interpret(((SemanticVersion)version).getVersionImpl());
        }
        throw new IllegalArgumentException("Semantic ranges expect semantic versions");
    }

    @Override
    public boolean isDiscrete() {
        return this.minimum != null && this.maximum == null;
    }

    @Override
    public boolean isSimple() {
        return this.minimum != null && this.maximum != null;
    }

    @Override
    public IVersion getMinimum() {
        return this.minimum;
    }

    @Override
    public IVersion getMaximum() {
        return this.maximum;
    }

    public String toString() {
        if (this.range != null) {
            return this.range;
        }
        if (this.maximum != null || this.minimum == null) {
            throw new UnsupportedOperationException("Cannot get string for range");
        }
        return this.minimum.toString();
    }

    @Override
    public String toMavenString() {
        if (this.range != null) {
            return "[" + this.minimum + "," + this.maximum + "]";
        }
        if (this.maximum != null || this.minimum == null) {
            throw new UnsupportedOperationException("Cannot get maven string for range");
        }
        return "[" + this.minimum.toString() + "]";
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IVersionRange getSimplifiedRange() {
        return this;
    }

    @Override
    public String getType() {
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    @Override
    public boolean hasErrors() {
        return this.hasErrors;
    }
}

