/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.InvalidRangeRuntimeException;
import net.ossindex.version.impl.AbstractCommonRange;
import net.ossindex.version.impl.OrRange;
import net.ossindex.version.impl.VersionRange;

public class AndRange
extends AbstractCommonRange {
    protected IVersionRange range1;
    protected IVersionRange range2;
    private String type;
    private boolean hasErrors = false;
    private boolean isBounded = false;

    public AndRange(IVersionRange range1, IVersionRange range2) throws InvalidRangeRuntimeException {
        if (!range1.intersects(range2)) {
            throw new InvalidRangeRuntimeException("Anded ranges do not intersect; this can never happen [" + range1 + " & " + range2 + "]");
        }
        if (range1 instanceof VersionRange && range2 instanceof VersionRange) {
            if (((VersionRange)range1).isUnbounded()) {
                if (((VersionRange)range2).isUnbounded()) {
                    IVersion v2;
                    IVersion v1 = range1.getMinimum();
                    if (v1.compareTo(v2 = range2.getMinimum()) <= 0) {
                        this.range1 = range1;
                        this.range2 = range2;
                    } else {
                        this.range2 = range1;
                        this.range1 = range2;
                    }
                } else {
                    this.range1 = range1;
                    this.range2 = range2;
                    this.isBounded = true;
                }
            } else if (((VersionRange)range2).isUnbounded()) {
                this.range2 = range1;
                this.range1 = range2;
                this.isBounded = true;
            } else {
                this.range1 = range1;
                this.range2 = range2;
            }
        } else if (range1 instanceof AndRange && ((AndRange)range1).isBounded && range2 instanceof VersionRange) {
            AndRange arange = (AndRange)range1;
            VersionRange boundingRange = (VersionRange)range2;
            if (boundingRange.isUnbounded()) {
                this.range2 = arange.last();
                this.range1 = boundingRange;
            } else {
                this.range1 = arange.first();
                this.range2 = boundingRange;
            }
        } else {
            this.range1 = range1;
            this.range2 = range2;
        }
    }

    @Override
    public boolean contains(IVersion version) {
        return this.range1.contains(version) && this.range2.contains(version);
    }

    @Override
    public boolean isDiscrete() {
        return false;
    }

    @Override
    public boolean isSimple() {
        return this.range1 instanceof VersionRange && this.range2 instanceof VersionRange && this.isBounded;
    }

    @Override
    public IVersion getMinimum() {
        IVersion v1 = this.range1.getMinimum();
        return v1;
    }

    @Override
    public IVersion getMaximum() {
        if (this.isBounded) {
            IVersion v2 = this.range2.getMaximum();
            return v2;
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean contains(IVersionRange yourRange) {
        if (this.range1 instanceof VersionRange && this.range2 instanceof VersionRange) {
            return this.range1.contains(yourRange) && this.range2.contains(yourRange);
        }
        return false;
    }

    public String getOperator() {
        return "&";
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        return this.range1.intersects(yourRange) && this.range2.intersects(yourRange);
    }

    @Override
    public IVersionRange getSimplifiedRange() {
        return this;
    }

    @Override
    public String getType() {
        if (this.type == null) {
            this.type = this.range1.getType();
        }
        if (this.type == null) {
            this.type = this.range2.getType();
        }
        return this.type;
    }

    @Override
    public void setType(String type) {
        this.type = type;
    }

    @Override
    public void setHasErrors(boolean b) {
        this.hasErrors = b;
    }

    @Override
    public boolean hasErrors() {
        if (this.hasErrors) {
            return true;
        }
        return this.range1.hasErrors() || this.range2.hasErrors();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (!this.range1.isDiscrete() && !this.range1.isSimple()) {
            sb.append("(").append(this.range1).append(")");
        } else {
            sb.append(this.range1);
        }
        sb.append(" ");
        if (!this.range2.isDiscrete() && !this.range2.isSimple()) {
            sb.append("(").append(this.range2).append(")");
        } else {
            sb.append(this.range2);
        }
        return sb.toString();
    }

    @Override
    public String toMavenString() {
        if (this.range1.isSimple() && this.range2.isSimple()) {
            StringBuilder sb = new StringBuilder();
            sb.append(this.range1.toMavenString());
            sb.append(this.range2.toMavenString());
            return sb.toString().replace(",)(,", ",");
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public IVersionRange invert() {
        IVersionRange irange1 = this.range1.invert();
        IVersionRange irange2 = this.range2.invert();
        return new OrRange(irange1, irange2);
    }

    public IVersionRange first() {
        return this.range1;
    }

    public IVersionRange last() {
        return this.range2;
    }
}

