/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Iterator;
import java.util.SortedSet;
import java.util.TreeSet;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;

public class VersionSet
implements IVersionRange,
Iterable<IVersion> {
    private SortedSet<IVersion> set = new TreeSet<IVersion>();

    public VersionSet(IVersion version) {
        this.set.add(version);
    }

    @Override
    public boolean contains(IVersion version) {
        return this.set.contains(version);
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IVersion getMinimum() {
        return this.set.first();
    }

    @Override
    public IVersion getMaximum() {
        return this.set.last();
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        Iterator it = this.set.iterator();
        while (it.hasNext()) {
            IVersion version = (IVersion)it.next();
            sb.append(version);
            if (!it.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public void add(IVersion version) {
        this.set.add(version);
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        for (IVersion version : this.set) {
            if (!yourRange.contains(version)) continue;
            return true;
        }
        return false;
    }

    @Override
    public Iterator<IVersion> iterator() {
        return this.set.iterator();
    }
}

