/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.Version;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.LogicalRange;
import net.ossindex.version.impl.SemanticVersion;
import net.ossindex.version.impl.VersionSet;

public class VersionRange
implements IVersionRange {
    private String operator;
    private SemanticVersion version;

    public VersionRange(String operator, SemanticVersion version) {
        this.version = version;
        this.operator = operator;
    }

    @Override
    public boolean contains(IVersion version) {
        if (version instanceof SemanticVersion) {
            Version myVer = this.version.getVersionImpl();
            Version yourVer = ((SemanticVersion)version).getVersionImpl();
            switch (this.operator) {
                case ">": {
                    return myVer.lessThan(yourVer);
                }
                case ">=": {
                    return myVer.lessThanOrEqualTo(yourVer);
                }
                case "<": {
                    return myVer.greaterThan(yourVer);
                }
                case "<=": {
                    return myVer.greaterThanOrEqualTo(yourVer);
                }
            }
            throw new IllegalArgumentException("Invalid operator: " + this.operator);
        }
        return false;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isSimple() {
        return true;
    }

    @Override
    public IVersion getMinimum() {
        switch (this.operator) {
            case "<": 
            case "<=": {
                return new SemanticVersion(0);
            }
            case ">": {
                return this.version;
            }
            case ">=": {
                return this.version;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + this.operator);
    }

    @Override
    public IVersion getMaximum() {
        switch (this.operator) {
            case "<": 
            case "<=": {
                return this.version;
            }
            case ">": 
            case ">=": {
                return null;
            }
        }
        throw new IllegalArgumentException("Invalid operator: " + this.operator);
    }

    public String toString() {
        return this.operator + this.version;
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        if (yourRange instanceof VersionSet) {
            return yourRange.intersects(this);
        }
        if (yourRange instanceof VersionRange) {
            if (yourRange.contains(this.version)) {
                return true;
            }
            return this.contains(((VersionRange)yourRange).version);
        }
        if (yourRange instanceof LogicalRange) {
            return yourRange.intersects(this);
        }
        throw new UnsupportedOperationException();
    }
}

