/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.VersionListener;
import net.ossindex.version.impl.VersionSet;
import net.ossindex.version.parser.VersionLexer;
import net.ossindex.version.parser.VersionParser;
import org.antlr.v4.runtime.ANTLRInputStream;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class VersionFactory {
    private static VersionFactory instance;

    private VersionFactory() {
    }

    public static synchronized VersionFactory getVersionFactory() {
        if (instance == null) {
            instance = new VersionFactory();
        }
        return instance;
    }

    public static IVersion getVersion(String vstring) {
        IVersionRange range = VersionFactory.getRange(vstring);
        return range.getMinimum();
    }

    public static IVersion getVersion(String hint, String version) {
        return VersionFactory.getVersion(version);
    }

    public static IVersionRange getRange(String vstring) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(vstring.getBytes(StandardCharsets.UTF_8));
            ANTLRInputStream input = new ANTLRInputStream((InputStream)stream);
            VersionLexer lexer = new VersionLexer((CharStream)input);
            CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
            VersionParser parser = new VersionParser((TokenStream)tokens);
            VersionParser.RangeContext context = parser.range();
            ParseTreeWalker walker = new ParseTreeWalker();
            VersionListener listener = new VersionListener();
            walker.walk((ParseTreeListener)listener, (ParseTree)context);
            IVersionRange range = listener.getRange();
            return range;
        }
        catch (Exception e) {
            e.printStackTrace();
            NamedVersion version = new NamedVersion(vstring);
            return new VersionSet(version);
        }
    }

    public static IVersionRange getRange(String[] versions) {
        return null;
    }
}

