/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import java.util.Stack;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.AndRange;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.OrRange;
import net.ossindex.version.impl.SemanticVersion;
import net.ossindex.version.impl.VersionRange;
import net.ossindex.version.impl.VersionSet;
import net.ossindex.version.parser.VersionBaseListener;
import net.ossindex.version.parser.VersionParser;

public class VersionListener
extends VersionBaseListener {
    private Stack<Object> stack = new Stack();
    private IVersionRange range;

    public IVersionRange getRange() {
        return this.range;
    }

    @Override
    public void exitNumeric_version(VersionParser.Numeric_versionContext ctx) {
        SemanticVersion version = null;
        int count = ctx.getChildCount();
        switch (count) {
            case 1: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                version = new SemanticVersion(major);
                break;
            }
            case 3: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                version = new SemanticVersion(major, minor);
                break;
            }
            case 5: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                int patch = Integer.parseInt(ctx.getChild(4).getText());
                version = new SemanticVersion(major, minor, patch);
                break;
            }
        }
        this.stack.push(version);
    }

    @Override
    public void exitPostfix_version(VersionParser.Postfix_versionContext ctx) {
        SemanticVersion version = null;
        int count = ctx.getChildCount();
        switch (count) {
            case 5: {
                int major = Integer.parseInt(ctx.getChild(0).getText());
                int minor = Integer.parseInt(ctx.getChild(2).getText());
                int patch = Integer.parseInt(ctx.getChild(4).getText());
                version = new SemanticVersion(major, minor, patch);
                break;
            }
            case 6: {
                version = new SemanticVersion(ctx.getChild(0).getText() + "." + ctx.getChild(2).getText() + "." + ctx.getChild(4).getText() + "-" + ctx.getChild(5).getText());
                break;
            }
            case 7: {
                version = new SemanticVersion(ctx.getText());
            }
        }
        this.stack.push(version);
    }

    @Override
    public void exitNamed_version(VersionParser.Named_versionContext ctx) {
        NamedVersion version = new NamedVersion(ctx.getText());
        this.stack.push(version);
    }

    @Override
    public void exitRange(VersionParser.RangeContext ctx) {
        Object o = this.stack.pop();
        if (o instanceof IVersion) {
            this.range = new VersionSet((IVersion)o);
        } else if (o instanceof IVersionRange) {
            this.range = (IVersionRange)o;
        }
    }

    @Override
    public void exitSimple_range(VersionParser.Simple_rangeContext ctx) {
        String operator = ctx.getChild(0).getText();
        Object o = this.stack.pop();
        if (!(o instanceof SemanticVersion)) {
            throw new AssertionError((Object)("Expected a semantic version, got a " + o.getClass().getSimpleName()));
        }
        this.range = new VersionRange(operator, (SemanticVersion)o);
        this.stack.push(this.range);
    }

    @Override
    public void exitVersion_set(VersionParser.Version_setContext ctx) {
        Object o1 = this.stack.pop();
        if (this.stack.isEmpty()) {
            VersionSet set = new VersionSet((IVersion)o1);
            this.stack.push(set);
        } else {
            VersionSet set = (VersionSet)this.stack.peek();
            set.add((IVersion)o1);
        }
    }

    @Override
    public void exitLogical_range(VersionParser.Logical_rangeContext ctx) {
        String first;
        if (ctx.getChildCount() == 2) {
            Object o1 = this.stack.pop();
            Object o2 = this.stack.pop();
            this.stack.push(new AndRange((IVersionRange)o2, (IVersionRange)o1));
        } else if (ctx.getChildCount() == 3 && !"(".equals(first = ctx.getChild(0).getText())) {
            String operator;
            Object o1 = this.stack.pop();
            Object o2 = this.stack.pop();
            switch (operator = ctx.getChild(1).getText()) {
                case "&": {
                    this.stack.push(new AndRange((IVersionRange)o2, (IVersionRange)o1));
                    break;
                }
                case "|": {
                    this.stack.push(new OrRange((IVersionRange)o2, (IVersionRange)o1));
                }
            }
        }
    }

    @Override
    public void enterIdentifier(VersionParser.IdentifierContext ctx) {
        System.err.println("WUT: '" + ctx.getText() + "'");
    }
}

