/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.expr.Expression;
import net.ossindex.version.IVersion;
import net.ossindex.version.IVersionRange;
import net.ossindex.version.impl.SemanticVersion;

public class BoundedVersionRange
implements IVersionRange {
    private Expression expression;
    private SemanticVersion minimum;
    private SemanticVersion maximum;
    private String range;

    public BoundedVersionRange(SemanticVersion version) {
        this.minimum = version;
    }

    @Override
    public boolean contains(IVersion version) {
        if (version instanceof SemanticVersion) {
            return this.expression.interpret(((SemanticVersion)version).getVersionImpl());
        }
        throw new IllegalArgumentException("Semantic ranges expect semantic versions");
    }

    @Override
    public boolean isAtomic() {
        return this.minimum != null && this.maximum == null;
    }

    @Override
    public boolean isSimple() {
        return this.minimum != null && this.maximum != null;
    }

    @Override
    public IVersion getMinimum() {
        return this.minimum;
    }

    @Override
    public IVersion getMaximum() {
        return this.maximum;
    }

    public String toString() {
        if (this.range != null) {
            return this.range;
        }
        if (this.minimum != null && this.maximum == null) {
            return this.minimum.toString();
        }
        throw new UnsupportedOperationException("Cannot get string for range");
    }

    @Override
    public boolean intersects(IVersionRange yourRange) {
        throw new UnsupportedOperationException();
    }
}

