/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.ParseException;
import com.github.zafarkhaja.semver.Parser;
import com.github.zafarkhaja.semver.expr.Expression;
import com.github.zafarkhaja.semver.expr.ExpressionParser;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.FlexibleSemanticVersion;
import net.ossindex.version.impl.IVersionRange;
import net.ossindex.version.impl.SemanticVersion;

public class SemanticVersionRange
implements IVersionRange {
    private Expression expression;
    private SemanticVersion minimum;
    private SemanticVersion maximum;
    private String range;

    public SemanticVersionRange(String range) {
        Parser parser = ExpressionParser.newInstance();
        this.expression = (Expression)parser.parse(range);
        this.range = range;
        try {
            FlexibleSemanticVersion version = new FlexibleSemanticVersion(range);
            this.minimum = version;
        }
        catch (ParseException parseException) {
            // empty catch block
        }
    }

    @Override
    public boolean contains(IVersion version) {
        if (version instanceof SemanticVersion) {
            return this.expression.interpret(((SemanticVersion)version).getVersionImpl());
        }
        throw new IllegalArgumentException("Semantic ranges expect semantic versions");
    }

    @Override
    public boolean isAtomic() {
        return this.minimum != null && this.maximum == null;
    }

    @Override
    public boolean isSimple() {
        return this.minimum != null && this.maximum != null;
    }

    @Override
    public IVersion getMinimum() {
        return this.minimum;
    }

    @Override
    public IVersion getMaximum() {
        return this.maximum;
    }

    public String toString() {
        return this.range;
    }
}

