/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.Version;
import net.ossindex.version.IVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SemanticVersion
implements Comparable<IVersion>,
IVersion {
    private static final Logger LOG = LoggerFactory.getLogger(SemanticVersion.class);
    private Version v;

    public SemanticVersion(String buf) {
        this.setVersion(buf);
    }

    protected SemanticVersion() {
    }

    protected void setVersion(String buf) {
        this.v = Version.valueOf((String)buf);
    }

    @Override
    public int getMajor() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getMajorVersion();
    }

    @Override
    public int getMinor() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getMinorVersion();
    }

    @Override
    public int getPatch() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getPatchVersion();
    }

    public boolean equals(Object o) {
        if (o instanceof SemanticVersion) {
            SemanticVersion v = (SemanticVersion)o;
            if (this.v != null) {
                return this.v.equals((Object)v.v);
            }
            return super.equals(v);
        }
        return false;
    }

    public int hashCode() {
        if (this.v != null) {
            return this.v.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(IVersion other) {
        if (other instanceof SemanticVersion) {
            SemanticVersion sv = (SemanticVersion)other;
            return this.v.compareTo(sv.v);
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public boolean isStable() {
        return true;
    }

    public Version getVersionImpl() {
        return this.v;
    }
}

