/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import net.ossindex.version.IVersion;
import net.ossindex.version.impl.SemanticVersion;

public class FlexibleSemanticVersion
extends SemanticVersion
implements Comparable<IVersion>,
IVersion {
    public FlexibleSemanticVersion(String buf) {
        this.setVersion(this.preprocess(buf));
    }

    private String preprocess(String buf) {
        int index = 0;
        while (index < buf.length()) {
            char c = buf.charAt(index);
            if ((c < '0' || c > '9') && c != '.') break;
            ++index;
        }
        String ver = buf.substring(0, index);
        String[] tokens = ver.split("\\.");
        StringBuilder sb = new StringBuilder();
        int tokenIndex = 0;
        while (tokenIndex < tokens.length) {
            String token = tokens[tokenIndex];
            if (tokenIndex > 0) {
                sb.append(".");
            }
            boolean hasNonZero = false;
            int i = 0;
            while (i < token.length()) {
                char c = token.charAt(i);
                if (hasNonZero) {
                    sb.append(c);
                } else if (c > '0' && c <= '9') {
                    sb.append(c);
                    hasNonZero = true;
                }
                ++i;
            }
            if (!hasNonZero) {
                sb.append('0');
            }
            ++tokenIndex;
        }
        buf = sb.toString();
        if (!buf.isEmpty() && tokens.length == 2) {
            sb.append(".0");
        }
        if (index < buf.length()) {
            String suffix = buf.substring(index);
            while (suffix.startsWith("-")) {
                suffix = suffix.substring(1);
            }
            sb.append("-").append(suffix);
        }
        return sb.toString();
    }
}

