/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import com.github.zafarkhaja.semver.expr.LexerException;
import com.github.zafarkhaja.semver.expr.UnexpectedTokenException;
import java.util.LinkedList;
import java.util.List;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.AetherVersionRange;
import net.ossindex.version.impl.IVersionRange;
import net.ossindex.version.impl.SemanticVersionRange;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public class VersionRange {
    private List<IVersionRange> ranges = new LinkedList<IVersionRange>();

    public VersionRange(String[] ranges) {
        String[] stringArray = ranges;
        int n = ranges.length;
        int n2 = 0;
        while (n2 < n) {
            String range = stringArray[n2];
            this.ranges.add(this.parse(range));
            ++n2;
        }
    }

    public VersionRange(String range) {
        this.ranges.add(this.parse(range));
    }

    private VersionRange(IVersionRange range) {
        this.ranges.add(range);
    }

    private IVersionRange parse(String range) {
        try {
            return new SemanticVersionRange(range);
        }
        catch (LexerException | UnexpectedTokenException throwable) {
        }
        catch (Exception e) {
            System.err.println("Exception parsing range: " + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        try {
            return new AetherVersionRange(range);
        }
        catch (InvalidVersionSpecificationException e) {
        }
        catch (Exception e) {
            System.err.println("Exception parsing range: " + e.getClass().getSimpleName());
            e.printStackTrace();
        }
        throw new UnsupportedOperationException("Cannot parse range: " + range);
    }

    boolean intersects(VersionRange target) {
        for (IVersionRange myRange : this.ranges) {
            for (IVersionRange yourRange : target.ranges) {
                if (myRange.isAtomic() && yourRange.contains(myRange.getMinimum())) {
                    return true;
                }
                if (yourRange.isAtomic() && myRange.contains(yourRange.getMinimum())) {
                    return true;
                }
                if (myRange.isSimple() && yourRange.contains(myRange.getMinimum()) && yourRange.contains(myRange.getMaximum())) {
                    return true;
                }
                if (!yourRange.isSimple() || !myRange.contains(yourRange.getMinimum()) || !myRange.contains(yourRange.getMaximum())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean contains(IVersion version) {
        for (IVersionRange myRange : this.ranges) {
            if (!myRange.contains(version)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        boolean first = true;
        for (IVersionRange myRange : this.ranges) {
            if (!first) {
                sb.append(",");
            }
            sb.append(myRange);
        }
        return sb.toString();
    }

    public VersionRange getSimplifiedRange() {
        IVersionRange maxRange = null;
        maxRange = this.ranges.get(this.ranges.size() - 1);
        String s = maxRange.toString();
        int index = s.lastIndexOf(38);
        int index2 = s.lastIndexOf(124);
        if (index2 > index) {
            index = index2;
        }
        if (index > 0) {
            s = s.substring(index + 1).trim();
            return new VersionRange(s);
        }
        return this;
    }
}

