/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import com.github.zafarkhaja.semver.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.AetherVersion;
import net.ossindex.version.impl.FlexibleSemanticVersion;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.NpmVersion;
import net.ossindex.version.impl.SemanticVersion;
import org.eclipse.aether.version.InvalidVersionSpecificationException;

public class VersionFactory {
    private static VersionFactory instance;
    public static Pattern mdmdp_s;
    public static Pattern mdm_s;
    public static Pattern m_s;

    static {
        mdmdp_s = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(.*)?$");
        mdm_s = Pattern.compile("^([0-9]+)\\.([0-9]+)(.*)?$");
        m_s = Pattern.compile("^([0-9]+)(.*)?$");
    }

    private VersionFactory() {
    }

    public static synchronized VersionFactory getVersionFactory() {
        if (instance == null) {
            instance = new VersionFactory();
        }
        return instance;
    }

    public IVersion getVersion(String buf) {
        if (buf == null || buf.isEmpty()) {
            throw new IllegalArgumentException("Input string is NULL or empty");
        }
        try {
            return new SemanticVersion(buf);
        }
        catch (ParseException parseException) {
            FlexibleSemanticVersion version = this.getFlexibleVersion(buf);
            if (version != null) {
                return version;
            }
            return new NamedVersion(buf);
        }
    }

    public IVersion getVersion(String hint, String version) {
        block7: {
            if (hint == null) break block7;
            switch (hint) {
                case "npm": {
                    return new NpmVersion(version);
                }
            }
        }
        return this.getVersion(version);
    }

    private FlexibleSemanticVersion getFlexibleVersion(String buf) {
        VersionParts parts = this.preprocess(buf);
        String ver = parts.version;
        String[] tokens = ver.split("\\.");
        switch (tokens.length) {
            case 2: {
                ver = String.valueOf(ver) + ".0";
                break;
            }
            case 3: {
                if (tokens[2].length() <= 1 || !tokens[2].startsWith("0")) break;
                ver = String.valueOf(tokens[0]) + "." + tokens[1] + ".0";
                if (parts.suffix == null) {
                    parts.suffix = "p" + tokens[2];
                    break;
                }
                parts.suffix = "p" + tokens[2] + "-" + parts.suffix;
                break;
            }
            case 4: {
                ver = String.valueOf(tokens[0]) + "." + tokens[1] + "." + tokens[2];
                if (parts.suffix == null) {
                    parts.suffix = "p" + tokens[3];
                    break;
                }
                parts.suffix = "p" + tokens[3] + "-" + parts.suffix;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            if (parts.suffix == null) {
                return new FlexibleSemanticVersion(ver);
            }
            parts.suffix = parts.suffix.trim();
            return new FlexibleSemanticVersion(String.valueOf(ver) + "-" + parts.suffix);
        }
        catch (Exception e) {
            return null;
        }
    }

    private VersionParts preprocess(String buf) {
        Matcher m;
        VersionParts version = new VersionParts();
        int index = 0;
        while (index < buf.length()) {
            char c = buf.charAt(index);
            if (c >= '0' && c <= '9') break;
            ++index;
        }
        if (index < buf.length()) {
            version.prefix = buf.substring(0, index);
            buf = buf.substring(index);
        }
        if ((m = mdmdp_s.matcher(buf)).matches()) {
            if (m.groupCount() == 4) {
                version.suffix = m.group(4);
            }
            version.version = String.valueOf(m.group(1)) + "." + m.group(2) + "." + m.group(3);
            return version;
        }
        m = mdm_s.matcher(buf);
        if (m.matches()) {
            if (m.groupCount() == 3) {
                version.suffix = m.group(3);
            }
            version.version = String.valueOf(m.group(1)) + "." + m.group(2) + ".0";
            return version;
        }
        m = m_s.matcher(buf);
        if (m.matches()) {
            if (m.groupCount() == 2) {
                version.suffix = m.group(2);
            }
            version.version = String.valueOf(m.group(1)) + ".0.0";
            return version;
        }
        version.version = buf;
        return version;
    }

    public <T> T adapt(Class<T> type, IVersion version) {
        if (type.isAssignableFrom(AetherVersion.class)) {
            try {
                return (T)new AetherVersion(version.toString());
            }
            catch (InvalidVersionSpecificationException invalidVersionSpecificationException) {
                // empty catch block
            }
        }
        throw new IllegalArgumentException("Cannot adapt version to " + type.getSimpleName() + " class");
    }

    class VersionParts {
        String suffix;
        String prefix;
        String version;

        VersionParts() {
        }
    }
}

