/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.Version;
import com.github.zafarkhaja.semver.expr.LexerException;
import net.ossindex.version.IVersion;

public class SemanticVersion
implements Comparable<IVersion>,
IVersion {
    private Version v;

    public SemanticVersion(String buf) {
        this.setVersion(buf);
    }

    protected SemanticVersion() {
    }

    protected void setVersion(String buf) {
        this.v = Version.valueOf((String)buf);
    }

    @Override
    public int getMajor() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getMajorVersion();
    }

    @Override
    public int getMinor() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getMinorVersion();
    }

    @Override
    public int getPatch() {
        if (this.v == null) {
            return 0;
        }
        return this.v.getPatchVersion();
    }

    @Override
    public boolean satisfies(String range) {
        if (this.v == null) {
            return false;
        }
        if (range.endsWith(".x")) {
            range = range.substring(0, range.length() - 2);
        }
        try {
            return this.v.satisfies(range);
        }
        catch (LexerException lexerException) {
            return false;
        }
    }

    public boolean equals(Object o) {
        if (o instanceof SemanticVersion) {
            SemanticVersion v = (SemanticVersion)o;
            if (this.v != null) {
                return this.v.equals((Object)v.v);
            }
            return super.equals(v);
        }
        return false;
    }

    public int hashCode() {
        if (this.v != null) {
            return this.v.hashCode();
        }
        return super.hashCode();
    }

    @Override
    public int compareTo(IVersion other) {
        if (other instanceof SemanticVersion) {
            SemanticVersion sv = (SemanticVersion)other;
            return this.v.compareTo(sv.v);
        }
        throw new UnsupportedOperationException();
    }

    public String toString() {
        return this.v.toString();
    }

    @Override
    public boolean isStable() {
        return true;
    }
}

