/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import com.github.zafarkhaja.semver.expr.LexerException;
import com.github.zafarkhaja.semver.expr.UnexpectedTokenException;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.FlexibleSemanticVersion;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NpmVersion
extends FlexibleSemanticVersion
implements IVersion {
    private static final Logger LOG = LoggerFactory.getLogger(NpmVersion.class);

    public NpmVersion(String buf) {
        super(NpmVersion.preprocess(buf));
    }

    private static String preprocess(String buf) {
        boolean doLoop = true;
        block3: while (doLoop && buf.length() != 0) {
            switch (buf.charAt(0)) {
                case '=': 
                case 'v': {
                    buf = buf.substring(1);
                    continue block3;
                }
            }
            doLoop = false;
        }
        return buf;
    }

    @Override
    public boolean satisfies(String range) {
        char c;
        if (range == null) {
            range = "*";
        }
        range = range.replaceAll("\\|\\|", "|");
        range = range.replaceAll("([0-9]+) +([<>=])", "$1 & $2");
        range = range.replaceAll("\\.x\\.x", ".x");
        if ((range = range.replaceAll("~([0-9]+)\\.([0-9]+)\\.x", "~$1.$2")).trim().isEmpty()) {
            range = "*";
        }
        if ((c = range.charAt(0)) >= 'a' && c <= 'z') {
            range = "*";
        }
        if (c >= 'A' && c <= 'Z') {
            range = "*";
        }
        if (range.contains("-")) {
            int index = range.indexOf(45);
            range = range.substring(0, index);
        }
        try {
            return super.satisfies(range);
        }
        catch (LexerException e) {
            LOG.error("Exception parsing range: '" + range + "'. Assuming satisfied.");
            return true;
        }
        catch (UnexpectedTokenException e) {
            LOG.error("Exception parsing range: '" + range + "'. Assuming satisfied.");
            return true;
        }
    }
}

