/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version.impl;

import net.ossindex.version.IVersion;
import net.ossindex.version.impl.SemanticVersion;

public class FlexibleSemanticVersion
extends SemanticVersion
implements Comparable<IVersion>,
IVersion {
    public FlexibleSemanticVersion(String buf) {
        this.setVersion(this.preprocess(buf));
    }

    private String preprocess(String buf) {
        char c;
        int index;
        for (index = 0; index < buf.length() && ((c = buf.charAt(index)) >= '0' && c <= '9' || c == '.'); ++index) {
        }
        String ver = buf.substring(0, index);
        String[] tokens = ver.split("\\.");
        StringBuilder sb = new StringBuilder();
        for (int tokenIndex = 0; tokenIndex < tokens.length; ++tokenIndex) {
            String token = tokens[tokenIndex];
            if (tokenIndex > 0) {
                sb.append(".");
            }
            boolean hasNonZero = false;
            for (int i = 0; i < token.length(); ++i) {
                char c2 = token.charAt(i);
                if (hasNonZero) {
                    sb.append(c2);
                    continue;
                }
                if (c2 <= '0' || c2 > '9') continue;
                sb.append(c2);
                hasNonZero = true;
            }
            if (hasNonZero) continue;
            sb.append('0');
        }
        buf = sb.toString();
        if (index < buf.length()) {
            String suffix = buf.substring(index);
            while (suffix.startsWith("-")) {
                suffix = suffix.substring(1);
            }
            buf = buf.substring(0, index) + "-" + suffix;
        }
        return buf;
    }
}

