/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import com.github.zafarkhaja.semver.Version;
import net.ossindex.version.impl.FlexibleSemanticVersion;

public class VersionRange {
    private String[] ranges;

    public VersionRange(String[] ranges) {
        this.ranges = ranges;
    }

    public VersionRange(String range) {
        if (range != null) {
            this.ranges = new String[1];
            this.ranges[0] = range;
        } else {
            this.ranges = new String[0];
        }
    }

    public boolean intersects(VersionRange range) {
        for (String myRange : this.ranges) {
            if (!this.intersects(myRange, range)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(String range1, VersionRange range2) {
        for (String childRange : range2.ranges) {
            if (!this.intersects(range1, childRange)) continue;
            return true;
        }
        return false;
    }

    private boolean intersects(String range1, String range2) {
        try {
            Version v1 = Version.valueOf((String)range1);
            return v1.satisfies(range2);
        }
        catch (Exception v1) {
            try {
                Version v2 = Version.valueOf((String)range2);
                return v2.satisfies(range1);
            }
            catch (Exception v2) {
                try {
                    FlexibleSemanticVersion v12 = new FlexibleSemanticVersion(range1);
                    return v12.satisfies(range2);
                }
                catch (Exception v12) {
                    try {
                        FlexibleSemanticVersion v22 = new FlexibleSemanticVersion(range2);
                        return v22.satisfies(range1);
                    }
                    catch (Exception exception) {
                        return false;
                    }
                }
            }
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < this.ranges.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(this.ranges[i]);
        }
        return sb.toString();
    }
}

