/*
 * Decompiled with CFR 0.152.
 */
package net.ossindex.version;

import com.github.zafarkhaja.semver.ParseException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.ossindex.version.IVersion;
import net.ossindex.version.impl.FlexibleSemanticVersion;
import net.ossindex.version.impl.NamedVersion;
import net.ossindex.version.impl.NpmVersion;
import net.ossindex.version.impl.SemanticVersion;

public class VersionFactory {
    private static VersionFactory instance;
    public static Pattern mdmdp_s;
    public static Pattern mdm_s;
    public static Pattern m_s;

    private VersionFactory() {
    }

    public static synchronized VersionFactory getVersionFactory() {
        if (instance == null) {
            instance = new VersionFactory();
        }
        return instance;
    }

    public IVersion getVersion(String buf) {
        if (buf == null || buf.isEmpty()) {
            throw new IllegalArgumentException("Input string is NULL or empty");
        }
        try {
            return new SemanticVersion(buf);
        }
        catch (ParseException parseException) {
            FlexibleSemanticVersion version = this.getFlexibleVersion(buf);
            if (version != null) {
                return version;
            }
            return new NamedVersion(buf);
        }
    }

    public IVersion getVersion(String hint, String version) {
        if (hint != null) {
            switch (hint) {
                case "npm": {
                    return new NpmVersion(version);
                }
            }
        }
        return this.getVersion(version);
    }

    private FlexibleSemanticVersion getFlexibleVersion(String buf) {
        VersionParts parts = this.preprocess(buf);
        String ver = parts.version;
        String[] tokens = ver.split("\\.");
        switch (tokens.length) {
            case 2: {
                ver = ver + ".0";
                break;
            }
            case 3: {
                if (tokens[2].length() <= 1 || !tokens[2].startsWith("0")) break;
                ver = tokens[0] + "." + tokens[1] + ".0";
                if (parts.suffix == null) {
                    parts.suffix = "p" + tokens[2];
                    break;
                }
                parts.suffix = "p" + tokens[2] + "-" + parts.suffix;
                break;
            }
            case 4: {
                ver = tokens[0] + "." + tokens[1] + "." + tokens[2];
                if (parts.suffix == null) {
                    parts.suffix = "p" + tokens[3];
                    break;
                }
                parts.suffix = "p" + tokens[3] + "-" + parts.suffix;
                break;
            }
            default: {
                return null;
            }
        }
        try {
            if (parts.suffix == null) {
                return new FlexibleSemanticVersion(ver);
            }
            parts.suffix = parts.suffix.trim();
            return new FlexibleSemanticVersion(ver + "-" + parts.suffix);
        }
        catch (Exception e) {
            return null;
        }
    }

    private VersionParts preprocess(String buf) {
        Matcher m;
        char c;
        int index;
        VersionParts version = new VersionParts();
        for (index = 0; index < buf.length() && ((c = buf.charAt(index)) < '0' || c > '9'); ++index) {
        }
        if (index < buf.length()) {
            version.prefix = buf.substring(0, index);
            buf = buf.substring(index);
        }
        if ((m = mdmdp_s.matcher(buf)).matches()) {
            if (m.groupCount() == 4) {
                version.suffix = m.group(4);
            }
            version.version = m.group(1) + "." + m.group(2) + "." + m.group(3);
            return version;
        }
        m = mdm_s.matcher(buf);
        if (m.matches()) {
            if (m.groupCount() == 3) {
                version.suffix = m.group(3);
            }
            version.version = m.group(1) + "." + m.group(2) + ".0";
            return version;
        }
        m = m_s.matcher(buf);
        if (m.matches()) {
            if (m.groupCount() == 2) {
                version.suffix = m.group(2);
            }
            version.version = m.group(1) + ".0.0";
            return version;
        }
        version.version = buf;
        return version;
    }

    static {
        mdmdp_s = Pattern.compile("^([0-9]+)\\.([0-9]+)\\.([0-9]+)(.*)?$");
        mdm_s = Pattern.compile("^([0-9]+)\\.([0-9]+)(.*)?$");
        m_s = Pattern.compile("^([0-9]+)(.*)?$");
    }

    class VersionParts {
        String suffix;
        String prefix;
        String version;

        VersionParts() {
        }
    }
}

