/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.spring.jms.listeners;

import javax.jms.ConnectionFactory;
import javax.jms.MessageListener;
import net.osgiliath.helpers.spring.jms.listeners.JmsTemplateContainerListenerFactory;
import net.osgiliath.helpers.spring.jms.listeners.ManageableDefaultJmsContainerListener;
import org.springframework.jms.listener.DefaultMessageListenerContainer;
import org.springframework.transaction.PlatformTransactionManager;

public class XACapableJmsTemplateContainerListenerFactory
implements JmsTemplateContainerListenerFactory {
    private PlatformTransactionManager txManager;
    private ConnectionFactory nonXAFactory;
    private ConnectionFactory xAFactory;
    private int concurrentConsumers;
    private int receiveTimeout;

    @Override
    public DefaultMessageListenerContainer create(boolean transacted, String destinationName, MessageListener messageListener) {
        return this.create(transacted, destinationName, messageListener, false);
    }

    @Override
    public DefaultMessageListenerContainer create(boolean transacted, String destinationName, MessageListener messageListener, boolean isPubSub) {
        ManageableDefaultJmsContainerListener container = new ManageableDefaultJmsContainerListener();
        container.setCacheLevel(4);
        container.setConcurrentConsumers(this.concurrentConsumers);
        container.setDestinationName(destinationName);
        container.setMessageListener(messageListener);
        container.setReceiveTimeout(this.receiveTimeout);
        container.setPubSubDomain(isPubSub);
        if (transacted) {
            this.addTransactedInfos(container);
        } else {
            this.addNonTransactedInfo(container);
            container.setSessionAcknowledgeMode(1);
        }
        container.initialize();
        container.start();
        return container;
    }

    private void addNonTransactedInfo(DefaultMessageListenerContainer container) {
        container.setConnectionFactory(this.nonXAFactory);
    }

    private void addTransactedInfos(DefaultMessageListenerContainer container) {
        container.setTransactionManager(this.txManager);
        container.setConnectionFactory(this.xAFactory);
        container.setTransactionTimeout(this.receiveTimeout);
    }

    public void setTxManager(PlatformTransactionManager txManager) {
        this.txManager = txManager;
    }

    public void setNonXAFactory(ConnectionFactory nonXAFactory) {
        this.nonXAFactory = nonXAFactory;
    }

    public void setXAFactory(ConnectionFactory xAFactory) {
        this.xAFactory = xAFactory;
    }

    public void setConcurrentConsumers(int concurrentConsumers) {
        this.concurrentConsumers = concurrentConsumers;
    }

    public void setReceiveTimeout(int receiveTimeout) {
        this.receiveTimeout = receiveTimeout;
    }
}

