/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.manifest.transformer;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.codehaus.plexus.util.IOUtil;

public class ManifestBundleImportVersionUpdaterTransformer {
    private transient Map<String, String> entriesVersionUpdates = new HashMap<String, String>();
    private transient boolean manifestDiscovered;
    private transient Manifest manifest;
    private static ManifestBundleImportVersionUpdaterTransformer instance;

    private static ManifestBundleImportVersionUpdaterTransformer getInstance() {
        if (instance == null) {
            instance = new ManifestBundleImportVersionUpdaterTransformer();
        }
        return instance;
    }

    public boolean canTransformResource(String resource) {
        return "META-INF/MANIFEST.MF".equalsIgnoreCase(resource);
    }

    public void processResource(InputStream is) throws IOException {
        if (!this.manifestDiscovered) {
            this.manifest = new Manifest(is);
            this.manifestDiscovered = true;
            IOUtil.close((InputStream)is);
        }
    }

    public void updateManifestImportsWithOverrides() throws IOException {
        if (this.manifest == null) {
            System.out.println("New Manifest");
            this.manifest = new Manifest();
        }
        Attributes attributes = this.manifest.getMainAttributes();
        StringBuilder updatedImports = new StringBuilder();
        if (this.entriesVersionUpdates != null) {
            String imports = attributes.getValue("Import-Package");
            StringBuilder regexp = new StringBuilder();
            regexp.append("([a-zA-Z0-9\\.]+?)");
            regexp.append("((;[^=]*?=([^;,]|,\\s*[\\.\\]\\)0-9a-zA-Z]*\")*?)*?)");
            regexp.append("(,(?!\\s*[\\.\\]\\)0-9a-zA-Z]*\")|$)");
            Pattern pattern = Pattern.compile(regexp.toString());
            Matcher matcher = pattern.matcher(imports);
            while (matcher.find()) {
                String symbolicName = matcher.group(1);
                Boolean foundMatch = Boolean.FALSE;
                updatedImports.append(symbolicName);
                for (String key : this.entriesVersionUpdates.keySet()) {
                    String specialization;
                    if (!key.equals(symbolicName) || (specialization = matcher.group(2)) == null) continue;
                    foundMatch = Boolean.TRUE;
                    System.out.println("Replacement matched: " + symbolicName + "," + specialization);
                    Pattern versionDeclarationPattern = Pattern.compile(";\\s*version\\s*=\\s*\"");
                    Matcher versionDeclarationMatcher = versionDeclarationPattern.matcher(specialization);
                    specialization = versionDeclarationMatcher.find() ? specialization.replaceAll(";\\s*version\\s*=\\s*\".*?\"", ";version=\"" + this.entriesVersionUpdates.get(key) + "\"") : specialization + ";version=\"" + this.entriesVersionUpdates.get(key) + "\"";
                    updatedImports.append(specialization);
                }
                if (!foundMatch.booleanValue()) {
                    String specialization = matcher.group(2);
                    updatedImports.append(specialization);
                }
                updatedImports.append(",");
            }
        }
        attributes.put(new Attributes.Name("Import-Package"), updatedImports.toString().substring(0, updatedImports.toString().length() - 1));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        String[] overrides = null;
        String basedir = null;
        String bundleClasspath = null;
        for (String arg : args) {
            if (arg.startsWith("overrides=")) {
                overrides = arg.replaceFirst("overrides=", "").split(";");
            } else if (arg.startsWith("basedir=")) {
                basedir = arg.replaceFirst("basedir=", "");
            } else if (arg.startsWith("bundleClasspath=")) {
                bundleClasspath = arg.replaceFirst("bundleClasspath=", "");
            }
            System.out.println("Argument: " + arg);
        }
        InputStream is = null;
        try {
            is = new FileInputStream(basedir + "/src/main/resources/META-INF/MANIFEST.MF");
            ManifestBundleImportVersionUpdaterTransformer.getInstance().processResource(is);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (null != is) {
                is.close();
            }
        }
        ManifestBundleImportVersionUpdaterTransformer.getInstance().createOverrideMap(overrides);
        ManifestBundleImportVersionUpdaterTransformer.getInstance().updateManifestImportsWithOverrides();
        ManifestBundleImportVersionUpdaterTransformer.getInstance().addBundleClassPath(bundleClasspath);
        ManifestBundleImportVersionUpdaterTransformer.getInstance().writeManifest(basedir);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeManifest(String basedir) throws IOException {
        OutputStream os = null;
        try {
            os = new FileOutputStream(basedir + "/src/main/resources/META-INF/MANIFEST.MF");
            this.manifest.write(os);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        finally {
            if (null != os) {
                os.close();
            }
        }
    }

    private void addBundleClassPath(String bundleClasspath) {
        Attributes attributes = this.manifest.getMainAttributes();
        attributes.put(new Attributes.Name("Bundle-ClassPath"), "., " + bundleClasspath + ".jar");
    }

    private void createOverrideMap(String[] overrides) {
        for (String override : overrides) {
            String[] mapEntry = override.split("=");
            if (mapEntry.length != 2) continue;
            this.entriesVersionUpdates.put(mapEntry[0], mapEntry[1]);
        }
    }
}

