/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.database.impl;

import java.io.PrintWriter;
import java.net.InetAddress;
import java.sql.Driver;
import java.sql.SQLException;
import java.util.Properties;
import javax.sql.ConnectionPoolDataSource;
import javax.sql.DataSource;
import javax.sql.XADataSource;
import net.osgiliath.database.constants.ClientConnectionConstant;
import net.osgiliath.database.impl.Activator;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.jdbc.ClientConnectionPoolDataSource40;
import org.apache.derby.jdbc.ClientDataSource;
import org.apache.derby.jdbc.ClientDataSource40;
import org.apache.derby.jdbc.ClientDriver40;
import org.apache.derby.jdbc.ClientXADataSource40;
import org.osgi.service.jdbc.DataSourceFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DerbyClientDatasourceFactory
implements DataSourceFactory {
    private static final Logger log = LoggerFactory.getLogger(DerbyClientDatasourceFactory.class);

    public DataSource createDataSource(Properties props) throws SQLException {
        ClientDataSource40 ds = new ClientDataSource40();
        this.setProperties((ClientDataSource)ds, props);
        return ds;
    }

    private void setProperties(ClientDataSource ds, Properties properties) throws SQLException {
        String databaseName;
        Properties props = (Properties)properties.clone();
        String doStartServer = (String)props.remove("serverAutoStart");
        if (doStartServer != null && Boolean.parseBoolean(doStartServer)) {
            this.doStartServer(props);
        }
        if ((databaseName = (String)props.remove("databaseName")) == null) {
            throw new SQLException("missing required property databaseName");
        }
        ds.setDatabaseName(databaseName);
        String password = (String)props.remove("password");
        ds.setPassword(password);
        String user = (String)props.remove("user");
        ds.setUser(user);
        String createDatabase = (String)props.remove("createDatabase");
        ds.setCreateDatabase(createDatabase);
        String serverName = (String)props.remove("serverName");
        ds.setServerName(serverName);
        String portNumber = (String)props.remove("portNumber");
        if (portNumber != null) {
            ds.setPortNumber(Integer.parseInt(portNumber));
        } else {
            ds.setPortNumber(1527);
        }
    }

    private void doStartServer(Properties properties) {
        String portNumberS;
        String host = (String)properties.get("serverName");
        if (host == null) {
            host = "localhost";
        }
        int portNumber = (portNumberS = (String)properties.get("portNumber")) == null ? 1527 : Integer.parseInt(portNumberS);
        boolean alreadyStarted = false;
        if (Activator.getInstance().getStartedServers().containsKey(host)) {
            alreadyStarted = Activator.getInstance().getStartedServers().get(host).contains(portNumber);
        }
        if (!alreadyStarted) {
            try {
                InetAddress adress = InetAddress.getByName(host);
                NetworkServerControl control = new NetworkServerControl(adress, portNumber);
                String writer = (String)properties.remove(ClientConnectionConstant.LOG_FILE_PROPERTY);
                if (writer == null) {
                    writer = "derbyServer.log";
                }
                PrintWriter printWriter = new PrintWriter(writer);
                control.start(printWriter);
                Activator.getInstance().addNetworkControl(host, portNumber, control);
            }
            catch (Exception e) {
                log.error("Error creating host adress", (Throwable)e);
            }
        }
    }

    public ConnectionPoolDataSource createConnectionPoolDataSource(Properties props) throws SQLException {
        ClientConnectionPoolDataSource40 ds = new ClientConnectionPoolDataSource40();
        this.setProperties((ClientDataSource)ds, props);
        return ds;
    }

    public XADataSource createXADataSource(Properties props) throws SQLException {
        ClientXADataSource40 ds = new ClientXADataSource40();
        this.setProperties((ClientDataSource)ds, props);
        return ds;
    }

    public Driver createDriver(Properties props) throws SQLException {
        ClientDriver40 driver = new ClientDriver40();
        return driver;
    }
}

