/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.database.impl;

import java.util.Collection;
import java.util.Dictionary;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import net.osgiliath.database.impl.DerbyClientDatasourceFactory;
import org.apache.derby.drda.NetworkServerControl;
import org.apache.derby.jdbc.ClientDriver;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.service.jdbc.DataSourceFactory;

public class Activator
implements BundleActivator {
    private final Map<String, Map<Integer, NetworkServerControl>> startedServers = new HashMap<String, Map<Integer, NetworkServerControl>>();
    private static Activator instance;

    public void start(BundleContext context) throws Exception {
        DerbyClientDatasourceFactory dsf = new DerbyClientDatasourceFactory();
        Hashtable<String, String> props = new Hashtable<String, String>();
        ((Dictionary)props).put("osgi.jdbc.driver.class", ClientDriver.class.getName());
        ((Dictionary)props).put("osgi.jdbc.driver.name", "derbyclient");
        context.registerService(DataSourceFactory.class.getName(), (Object)dsf, props);
        instance = this;
    }

    public void stop(BundleContext context) throws Exception {
        for (Map<Integer, NetworkServerControl> controls : Activator.getInstance().startedServers.values()) {
            for (NetworkServerControl control : controls.values()) {
                control.shutdown();
            }
        }
        Activator.getInstance().startedServers.clear();
    }

    protected static Activator getInstance() {
        return instance;
    }

    protected Map<String, Collection<Integer>> getStartedServers() {
        HashMap<String, Collection<Integer>> ret = new HashMap<String, Collection<Integer>>();
        for (Map.Entry<String, Map<Integer, NetworkServerControl>> keys : this.startedServers.entrySet()) {
            ret.put(keys.getKey(), keys.getValue().keySet());
        }
        return ret;
    }

    protected void addNetworkControl(String host, int port, NetworkServerControl control) {
        Map<Integer, NetworkServerControl> candidate = this.startedServers.get(host);
        if (candidate == null) {
            candidate = new HashMap<Integer, NetworkServerControl>();
            this.startedServers.put(host, candidate);
        }
        candidate.put(port, control);
    }
}

