/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.cxf.exception.handling.jaxrs.mapper;

import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.output.Format;
import org.jdom2.output.XMLOutputter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ExceptionXmlMapper
implements ExceptionMapper<Exception> {
    private static final Logger LOG = LoggerFactory.getLogger(ExceptionXmlMapper.class);

    public Response toResponse(Exception arg0) {
        Element root = new Element("Exception");
        Document doc = new Document(root);
        this.populateXML(arg0, root);
        String res = new XMLOutputter(Format.getPrettyFormat()).outputString(doc);
        LOG.info("CXF exception thrown: " + res, (Throwable)arg0);
        return Response.status((Response.Status)Response.Status.FORBIDDEN).type("application/xml").header("ExceptionBody", (Object)res).build();
    }

    private void populateXML(Throwable arg0, Element root) {
        Element clazz = new Element("class");
        clazz.setText(arg0.getClass().getSimpleName());
        root.getChildren().add(clazz);
        Element message = new Element("message");
        message.setText(arg0.getMessage());
        root.getChildren().add(message);
        Element localizedMessage = new Element("localizedMessage");
        localizedMessage.setText(arg0.getLocalizedMessage());
        root.getChildren().add(localizedMessage);
        if (arg0.getCause() != null) {
            Element cause = new Element("Cause");
            root.getChildren().add(cause);
            this.populateXML(arg0.getCause(), cause);
        }
    }
}

