/*
 * Decompiled with CFR 0.152.
 */
package helpers.cxf.exception.handling.camel.processor;

import java.io.Reader;
import java.io.StringReader;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrownExceptionMessageToInBodyProcessor
implements Processor {
    private static Logger LOG = LoggerFactory.getLogger(ThrownExceptionMessageToInBodyProcessor.class);

    public void process(Exchange exchange) throws Exception {
        HttpOperationFailedException c = (HttpOperationFailedException)exchange.getProperty("CamelExceptionCaught", HttpOperationFailedException.class);
        SAXBuilder sxb = new SAXBuilder();
        if (c != null && c.getResponseHeaders().get("ExceptionBody") != null) {
            String body = (String)c.getResponseHeaders().get("ExceptionBody");
            LOG.info("Catched error in route: " + body);
            Document doc = sxb.build((Reader)new StringReader(body));
            exchange.getIn().setBody((Object)doc.getRootElement().getChild("message").getText());
        }
    }
}

