/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.cdi.cxf.jaxrs.internal.trackers;

import java.util.Collection;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.registry.InterceptorsServiceRegistry;
import org.apache.cxf.interceptor.Interceptor;
import org.osgi.framework.BundleContext;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public final class InterceptorsServiceTracker
implements ServiceTrackerCustomizer {
    private final BundleContext context;

    public InterceptorsServiceTracker(BundleContext context) {
        this.context = context;
    }

    public final Object addingService(ServiceReference reference) {
        Object serviceObject = this.context.getService(reference);
        if (serviceObject instanceof Interceptor) {
            InterceptorsServiceRegistry.getInstance().getInterceptors().add((Interceptor)serviceObject);
        }
        return reference;
    }

    public final void removedService(ServiceReference reference, Object service) {
        Object serviceObject = this.context.getService(reference);
        if (serviceObject instanceof Interceptor) {
            InterceptorsServiceRegistry.getInstance().getInterceptors().remove((Interceptor)serviceObject);
        }
    }

    public static void handleInitialReferences(BundleContext context) throws InvalidSyntaxException {
        Collection refs = context.getServiceReferences(Interceptor.class, null);
        for (ServiceReference reference : refs) {
            Interceptor svc = (Interceptor)context.getService(reference);
            svc.toString();
            InterceptorsServiceRegistry.getInstance().getInterceptors().add(svc);
        }
    }

    public void modifiedService(ServiceReference reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }
}

