/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.cdi.cxf.jaxrs.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.PreDestroy;
import javax.enterprise.context.spi.Contextual;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.ProcessBean;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.core.Application;
import javax.ws.rs.ext.RuntimeDelegate;
import net.osgiliath.helpers.cdi.cxf.jaxrs.CXFEndpoint;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.CXFHelperActivator;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.registry.ProvidersServiceRegistry;
import org.apache.commons.lang.ClassUtils;
import org.apache.cxf.Bus;
import org.apache.cxf.binding.BindingFactory;
import org.apache.cxf.binding.BindingFactoryManager;
import org.apache.cxf.bus.CXFBusFactory;
import org.apache.cxf.endpoint.Server;
import org.apache.cxf.jaxrs.JAXRSBindingFactory;
import org.apache.cxf.jaxrs.JAXRSServerFactoryBean;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EndpointPublishingExtension
implements Extension {
    private static final Logger LOG = LoggerFactory.getLogger(EndpointPublishingExtension.class);
    private List<Server> servers = new ArrayList<Server>();
    private Collection<ProcessBean> beansToProcess = Sets.newHashSet();
    private Map<String, JAXRSServerFactoryBean> factoriesMap = Maps.newHashMap();

    public <X> void processPublishJaxRSServices(@Observes ProcessBean<X> process, BeanManager manager) {
        boolean isService;
        if (process.getBean() instanceof Interceptor || process.getBean() instanceof Decorator || !(process.getAnnotated() instanceof AnnotatedType)) {
            return;
        }
        AnnotatedType annotatedType = (AnnotatedType)process.getAnnotated();
        if (annotatedType.getAnnotation(CXFEndpoint.class) == null) {
            return;
        }
        ArrayList<Class> interfaces = new ArrayList<Class>(ClassUtils.getAllInterfaces((Class)annotatedType.getJavaClass()));
        interfaces.addAll(ClassUtils.getAllSuperclasses((Class)annotatedType.getJavaClass()));
        if (interfaces.isEmpty()) {
            process.addDefinitionError((Throwable)new IllegalArgumentException(String.format("JaxRS service %s must implement at least an interface/class", annotatedType.getJavaClass().getName())));
        }
        if (!(isService = this.checkIsService(interfaces))) {
            process.addDefinitionError((Throwable)new IllegalArgumentException(String.format("JaxRS service %s must implement at least an interface that's has REST annotations", annotatedType.getJavaClass().getName())));
        }
        if (annotatedType.getJavaClass().isAnnotationPresent(CXFEndpoint.class)) {
            this.beansToProcess.add(process);
        }
    }

    private boolean checkIsService(List<Class> interfaces) {
        boolean isService = false;
        for (Class interfacee : interfaces) {
            if (interfacee.getAnnotation(Path.class) != null || interfacee.getAnnotation(GET.class) != null || interfacee.getAnnotation(POST.class) != null || interfacee.getAnnotation(PUT.class) != null || interfacee.getAnnotation(DELETE.class) != null) {
                return true;
            }
            for (Method method : interfacee.getMethods()) {
                if (method.getAnnotation(Path.class) == null && method.getAnnotation(GET.class) == null && method.getAnnotation(POST.class) == null && method.getAnnotation(PUT.class) == null && method.getAnnotation(DELETE.class) == null) continue;
                return true;
            }
        }
        return isService;
    }

    private <X> void registerRSService(@Observes AfterDeploymentValidation event, BeanManager manager) throws ClassNotFoundException {
        JAXRSServerFactoryBean factory;
        HashMap factories = Maps.newHashMap();
        for (ProcessBean processBean : this.beansToProcess) {
            CXFEndpoint endpointAnnotation = (CXFEndpoint)processBean.getAnnotated().getAnnotation(CXFEndpoint.class);
            factory = this.getFactory(endpointAnnotation.factoryId());
            this.addProviders(factory, endpointAnnotation.providersClasses());
            this.addInterceptors(factory, endpointAnnotation);
            String serviceURL = endpointAnnotation.url();
            factory.setAddress(serviceURL);
            factories.put(serviceURL, factory);
        }
        for (Map.Entry entry : factories.entrySet()) {
            ArrayList instancesToPut = Lists.newArrayList();
            for (ProcessBean processBean : this.beansToProcess) {
                CXFEndpoint endpointAnnotation = (CXFEndpoint)processBean.getAnnotated().getAnnotation(CXFEndpoint.class);
                String serviceURL = endpointAnnotation.url();
                if (!serviceURL.equals(entry.getKey())) continue;
                Bean bean = processBean.getBean();
                Object instance = manager.getReference(bean, (Type)bean.getBeanClass(), manager.createCreationalContext((Contextual)bean));
                instancesToPut.add(instance);
                LOG.info("instance: " + bean + ", managed: ");
                LOG.info("Creating CXF Endpoint for " + bean.getBeanClass().getName() + " " + "on service address: " + serviceURL);
            }
            factory = (JAXRSServerFactoryBean)entry.getValue();
            factory.setServiceBeans((List)instancesToPut);
            this.servers.add(factory.create());
        }
    }

    private void addInterceptors(JAXRSServerFactoryBean factory, CXFEndpoint endpointAnnotation) throws ClassNotFoundException {
        this.addInFaultInterceptors(factory, endpointAnnotation.inFaultInterceptors());
        this.addInInterceptors(factory, endpointAnnotation.inInterceptors());
        this.addOutFaultInterceptors(factory, endpointAnnotation.outFaultInterceptors());
        this.addOutInterceptors(factory, endpointAnnotation.outInterceptors());
    }

    private void addOutInterceptors(JAXRSServerFactoryBean factory, Class<? extends Interceptor<? extends Message>>[] outInterceptors) throws ClassNotFoundException {
        HashSet interceptors = Sets.newHashSet((Iterable)factory.getOutInterceptors());
        this.fillInterceptorList(interceptors, outInterceptors);
        factory.setOutInterceptors((List)Lists.newArrayList((Iterable)interceptors));
    }

    private void addOutFaultInterceptors(JAXRSServerFactoryBean factory, Class<? extends Interceptor<? extends Message>>[] outFaultInterceptors) throws ClassNotFoundException {
        HashSet interceptors = Sets.newHashSet((Iterable)factory.getOutFaultInterceptors());
        this.fillInterceptorList(interceptors, outFaultInterceptors);
        factory.setOutFaultInterceptors((List)Lists.newArrayList((Iterable)interceptors));
    }

    private void addInInterceptors(JAXRSServerFactoryBean factory, Class<? extends Interceptor<? extends Message>>[] inInterceptors) throws ClassNotFoundException {
        HashSet interceptors = Sets.newHashSet((Iterable)factory.getInInterceptors());
        this.fillInterceptorList(interceptors, inInterceptors);
        factory.setInInterceptors((List)Lists.newArrayList((Iterable)interceptors));
    }

    private void addInFaultInterceptors(JAXRSServerFactoryBean factory, Class<? extends Interceptor<? extends Message>>[] inFaultInterceptors) throws ClassNotFoundException {
        HashSet interceptors = Sets.newHashSet((Iterable)factory.getInFaultInterceptors());
        this.fillInterceptorList(interceptors, inFaultInterceptors);
        factory.setInFaultInterceptors((List)Lists.newArrayList((Iterable)interceptors));
    }

    private void fillInterceptorList(Set<org.apache.cxf.interceptor.Interceptor<? extends Message>> setToFill, Class<? extends Interceptor<? extends Message>>[] toAddInterceptors) throws ClassNotFoundException {
        for (Class<? extends Interceptor<? extends Message>> clazz : toAddInterceptors) {
            boolean found = false;
            for (Object provider : ProvidersServiceRegistry.getInstance().getProviders()) {
                if (!clazz.isInstance(provider)) continue;
                found = true;
                setToFill.add((org.apache.cxf.interceptor.Interceptor<? extends Message>)((org.apache.cxf.interceptor.Interceptor)provider));
                break;
            }
            if (found) continue;
            throw new ClassNotFoundException("Interceptor " + clazz.getName() + " could not be instantiated");
        }
    }

    private JAXRSServerFactoryBean getFactory(String factoryId) {
        JAXRSServerFactoryBean factory = this.factoriesMap.get(factoryId);
        if (factory == null) {
            factory = (JAXRSServerFactoryBean)RuntimeDelegate.getInstance().createEndpoint((Application)CXFHelperActivator.getPlugin().getJaxRSApplication(), JAXRSServerFactoryBean.class);
            Bus bus = CXFBusFactory.getDefaultBus();
            if (bus == null) {
                LOG.info("Creating a new Bus");
                bus = CXFBusFactory.newInstance().createBus();
            } else {
                LOG.info("registering on existing bus");
            }
            factory.setBus(bus);
            BindingFactoryManager manager = (BindingFactoryManager)factory.getBus().getExtension(BindingFactoryManager.class);
            JAXRSBindingFactory bindingFactory = new JAXRSBindingFactory();
            bindingFactory.setBus(factory.getBus());
            manager.registerBindingFactory("http://apache.org/cxf/binding/jaxrs", (BindingFactory)bindingFactory);
        }
        return factory;
    }

    private void addProviders(JAXRSServerFactoryBean factory, Class[] clazzes) throws ClassNotFoundException {
        HashSet providers = Sets.newHashSet((Iterable)factory.getProviders());
        for (Class clazz : clazzes) {
            boolean found = false;
            for (Object provider : ProvidersServiceRegistry.getInstance().getProviders()) {
                if (!clazz.isInstance(provider)) continue;
                found = true;
                providers.add(provider);
                break;
            }
            if (found) continue;
            throw new ClassNotFoundException("Provider " + clazz.getName() + " could not be instantiated");
        }
        factory.setProviders((List)Lists.newArrayList((Iterable)providers));
    }

    @PreDestroy
    public void destroy() {
        for (Server server : this.servers) {
            server.destroy();
        }
    }
}

