/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.cdi.cxf.jaxrs.internal;

import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.MessageBodyReader;
import javax.ws.rs.ext.MessageBodyWriter;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.JaxRsApiApplication;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.trackers.ExceptionMapperProvidersServiceTracker;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.trackers.InterceptorsServiceTracker;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.trackers.MessageBodyReaderProvidersServiceTracker;
import net.osgiliath.helpers.cdi.cxf.jaxrs.internal.trackers.MessageBodyWriterProvidersServiceTracker;
import org.apache.cxf.interceptor.Interceptor;
import org.osgi.framework.BundleActivator;
import org.osgi.framework.BundleContext;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class CXFHelperActivator
implements BundleActivator {
    private ServiceTracker readerTracker;
    private ServiceTracker writerTracker;
    private ServiceTracker exceptionTracker;
    private ServiceTracker interceptorsTracker;
    private JaxRsApiApplication jaxRSApplication;
    private static CXFHelperActivator plugin;

    public void start(BundleContext context) throws Exception {
        this.readerTracker = new ServiceTracker(context, MessageBodyReader.class, (ServiceTrackerCustomizer)new MessageBodyReaderProvidersServiceTracker(context));
        this.readerTracker.open(true);
        this.writerTracker = new ServiceTracker(context, MessageBodyWriter.class, (ServiceTrackerCustomizer)new MessageBodyWriterProvidersServiceTracker(context));
        this.writerTracker.open(true);
        this.exceptionTracker = new ServiceTracker(context, ExceptionMapper.class, (ServiceTrackerCustomizer)new ExceptionMapperProvidersServiceTracker(context));
        this.exceptionTracker.open(true);
        this.interceptorsTracker = new ServiceTracker(context, Interceptor.class, (ServiceTrackerCustomizer)new InterceptorsServiceTracker(context));
        this.interceptorsTracker.open(true);
        MessageBodyReaderProvidersServiceTracker.handleInitialReferences(context);
        MessageBodyWriterProvidersServiceTracker.handleInitialReferences(context);
        ExceptionMapperProvidersServiceTracker.handleInitialReferences(context);
        InterceptorsServiceTracker.handleInitialReferences(context);
        this.jaxRSApplication = new JaxRsApiApplication();
        plugin = this;
    }

    public JaxRsApiApplication getJaxRSApplication() {
        return this.jaxRSApplication;
    }

    public static CXFHelperActivator getPlugin() {
        return plugin;
    }

    public void stop(BundleContext context) throws Exception {
        this.readerTracker.close();
        this.writerTracker.close();
        this.exceptionTracker.close();
        this.interceptorsTracker.close();
    }
}

