/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helpers.camel;

import java.io.Reader;
import java.io.StringReader;
import org.apache.camel.Exchange;
import org.apache.camel.Processor;
import org.apache.camel.component.http.HttpOperationFailedException;
import org.jdom2.Document;
import org.jdom2.input.SAXBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThrownExceptionMessageToInBodyProcessor
implements Processor {
    private static Logger LOG = LoggerFactory.getLogger(ThrownExceptionMessageToInBodyProcessor.class);

    public void process(Exchange exchange) throws Exception {
        HttpOperationFailedException exception = (HttpOperationFailedException)exchange.getProperty("CamelExceptionCaught", HttpOperationFailedException.class);
        if (null != exception && null != exception.getResponseHeaders().get("ExceptionBody")) {
            String body = (String)exception.getResponseHeaders().get("ExceptionBody");
            LOG.info("Catched error in route: " + body);
            SAXBuilder sxb = new SAXBuilder();
            Document doc = sxb.build((Reader)new StringReader(body));
            exchange.getIn().setBody((Object)doc.getRootElement().getChild("message").getText());
        }
    }
}

