/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helper.exam;

import java.io.File;
import org.ops4j.pax.exam.CoreOptions;
import org.ops4j.pax.exam.MavenUtils;
import org.ops4j.pax.exam.Option;
import org.ops4j.pax.exam.OptionUtils;
import org.ops4j.pax.exam.karaf.options.KarafDistributionOption;
import org.ops4j.pax.exam.karaf.options.LogLevelOption;
import org.ops4j.pax.exam.options.DefaultCompositeOption;
import org.ops4j.pax.exam.options.MavenUrlReference;
import org.ops4j.pax.exam.options.extra.VMOption;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPaxExamKarafConfiguration {
    private static final Logger log = LoggerFactory.getLogger(AbstractPaxExamKarafConfiguration.class);
    private static final String PAX_URL_MVN_SETTINGS_PROPERTY = "org.ops4j.pax.url.mvn.settings";
    private static final String PAX_URL_MVN_CFG = "etc/org.ops4j.pax.url.mvn.cfg";
    protected static final String COVERAGE_COMMAND = "jcoverage.command";
    protected static final String CONFIGURED_MAVEN_USER_SETTINGS = "maven.user.settings";
    protected static final String DEFAULT_MAVEN_USER_SETTINGS = "maven.user.settings.default";
    protected static final String DEFAULT_MAVEN_GLOBAL_SETTINGS = "maven.global.settings.default";
    protected static final String MODULE_GROUP_ID = "project.groupId";
    protected static final String MODULE_PARENT_ARTIFACT_ID = "project.parent.artifactId";
    protected static final String MODULE_ARTIFACT_ID = "project.artifactId";
    protected static final String MAVEN_REPOS_URLS = "maven.repos.urls";
    protected static final String DEBUG_VM_OPTION = "-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=31313";
    private static final String MAX_HEAP = "-Xmx512m";
    private static final String MIN_HEAP = "-Xms128m";
    private static final String MAX_PERM = "-XX:MaxPermSize=256m";
    protected static String paxRunnerVmOption;

    public Option[] createConfig() {
        Option[] base = CoreOptions.options((Option[])new Option[]{CoreOptions.cleanCaches(), KarafDistributionOption.karafDistributionConfiguration().frameworkUrl((MavenUrlReference)CoreOptions.maven().groupId("org.apache.karaf").artifactId("apache-karaf").type("zip").versionAsInProject()).name("Apache Karaf").karafVersion(MavenUtils.getArtifactVersion((String)"org.apache.karaf", (String)"apache-karaf")).unpackDirectory(new File("target/exam/unpack/")), KarafDistributionOption.keepRuntimeFolder(), CoreOptions.junitBundles(), this.addCodeCoverageOption(), this.addMavenSettingsOptions(), this.mavenReposURLOptions(), this.loggingLevel(), this.addExtraOptions(), this.featureToTest()});
        Option[] baseAndJVM = OptionUtils.combine((Option[])base, (Option[])this.addJVMOptions());
        VMOption vmOption = paxRunnerVmOption != null ? CoreOptions.vmOption((String)paxRunnerVmOption) : null;
        return OptionUtils.combine((Option[])baseAndJVM, (Option[])new Option[]{vmOption});
    }

    private Option mavenReposURLOptions() {
        if (System.getProperty(MAVEN_REPOS_URLS) != null) {
            log.info("replacing repositories urls by: " + System.getProperty(MAVEN_REPOS_URLS));
            return KarafDistributionOption.editConfigurationFilePut((String)PAX_URL_MVN_CFG, (String)"org.ops4j.pax.url.mvn.repositories", (String)System.getProperty(MAVEN_REPOS_URLS));
        }
        return new DefaultCompositeOption();
    }

    private Option addMavenSettingsOptions() {
        if (System.getProperty(CONFIGURED_MAVEN_USER_SETTINGS) != null) {
            log.info("adding user reference settings " + System.getProperty(CONFIGURED_MAVEN_USER_SETTINGS));
            return KarafDistributionOption.editConfigurationFilePut((String)PAX_URL_MVN_CFG, (String)PAX_URL_MVN_SETTINGS_PROPERTY, (String)System.getProperty(CONFIGURED_MAVEN_USER_SETTINGS));
        }
        if (System.getProperty(DEFAULT_MAVEN_USER_SETTINGS) != null) {
            log.info("adding user reference settings " + System.getProperty(DEFAULT_MAVEN_USER_SETTINGS));
            return KarafDistributionOption.editConfigurationFilePut((String)PAX_URL_MVN_CFG, (String)PAX_URL_MVN_SETTINGS_PROPERTY, (String)System.getProperty(DEFAULT_MAVEN_USER_SETTINGS));
        }
        if (System.getProperty(DEFAULT_MAVEN_GLOBAL_SETTINGS) != null) {
            log.info("adding global reference settings " + System.getProperty(DEFAULT_MAVEN_GLOBAL_SETTINGS));
            return KarafDistributionOption.editConfigurationFilePut((String)PAX_URL_MVN_CFG, (String)PAX_URL_MVN_SETTINGS_PROPERTY, (String)System.getProperty(DEFAULT_MAVEN_GLOBAL_SETTINGS));
        }
        return new DefaultCompositeOption();
    }

    private Option[] addJVMOptions() {
        return CoreOptions.options((Option[])new Option[]{CoreOptions.vmOption((String)MAX_HEAP), CoreOptions.vmOption((String)MIN_HEAP), CoreOptions.vmOption((String)MAX_PERM)});
    }

    private Option addCodeCoverageOption() {
        String coverageCommand = System.getProperty(COVERAGE_COMMAND);
        if (coverageCommand != null && !coverageCommand.isEmpty()) {
            log.info("covering code with command " + coverageCommand);
            return CoreOptions.vmOption((String)coverageCommand);
        }
        return new DefaultCompositeOption();
    }

    protected Option loggingLevel() {
        return KarafDistributionOption.logLevel((LogLevelOption.LogLevel)LogLevelOption.LogLevel.INFO);
    }

    protected Option addExtraOptions() {
        return new DefaultCompositeOption();
    }

    protected abstract Option featureToTest();
}

