/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helper.deltaspike.tx;

import java.io.IOException;
import java.lang.annotation.Annotation;
import javax.enterprise.context.Dependent;
import javax.enterprise.inject.Alternative;
import javax.inject.Inject;
import javax.interceptor.InvocationContext;
import javax.persistence.EntityManager;
import javax.persistence.EntityTransaction;
import javax.transaction.SystemException;
import javax.transaction.UserTransaction;
import net.osgiliath.helper.deltaspike.configadmin.ConfigAdminAccessor;
import org.apache.deltaspike.core.util.ExceptionUtils;
import org.apache.deltaspike.jpa.api.transaction.TransactionConfig;
import org.apache.deltaspike.jpa.impl.transaction.ResourceLocalTransactionStrategy;
import org.apache.deltaspike.jpa.impl.transaction.context.EntityManagerEntry;
import org.ops4j.pax.cdi.api.OsgiService;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Dependent
@Alternative
public class OsgiUserTransactionStrategy
extends ResourceLocalTransactionStrategy {
    private static final long serialVersionUID = -2432802805095533499L;
    private static final Logger LOGGER = LoggerFactory.getLogger(OsgiUserTransactionStrategy.class);
    private transient TransactionConfig transactionConfig;
    @Inject
    @OsgiService(required=true)
    private UserTransaction userTransaction;

    protected EntityManagerEntry createEntityManagerEntry(EntityManager entityManager, Class<? extends Annotation> qualifier) {
        this.applyTransactionTimeout();
        return super.createEntityManagerEntry(entityManager, qualifier);
    }

    protected void applyTransactionTimeout() {
        Integer transactionTimeout = this.getDefaultTransactionTimeoutInSeconds();
        if (transactionTimeout == null) {
            return;
        }
        try {
            UserTransaction userTransaction = this.resolveUserTransaction();
            if (userTransaction != null && userTransaction.getStatus() != 0) {
                this.userTransaction.setTransactionTimeout(transactionTimeout.intValue());
            }
        }
        catch (SystemException e) {
            LOGGER.warn("UserTransaction#setTransactionTimeout failed", (Throwable)e);
        }
    }

    protected Integer getDefaultTransactionTimeoutInSeconds() {
        if (this.transactionConfig == null) {
            this.lazyInit();
        }
        return this.transactionConfig.getUserTransactionTimeoutInSeconds();
    }

    protected synchronized void lazyInit() {
        if (this.transactionConfig != null) {
            return;
        }
        this.transactionConfig = this.createDefaultTransactionConfig();
    }

    protected TransactionConfig createDefaultTransactionConfig() {
        return new TransactionConfig(){
            private static final long serialVersionUID = -3915439087580270117L;

            public Integer getUserTransactionTimeoutInSeconds() {
                int ret = 600;
                try {
                    String prop = ConfigAdminAccessor.getProperty((BundleContext)FrameworkUtil.getBundle(this.getClass()).getBundleContext(), (String)"aries.transaction.timeout");
                    LOGGER.info("setting transaction timeout to:" + prop);
                    if (prop != null && !prop.isEmpty()) {
                        ret = Integer.valueOf(prop);
                    }
                }
                catch (IOException | NumberFormatException | InvalidSyntaxException e) {
                    LOGGER.error("unable to find default transaction timeout", e);
                }
                return ret;
            }
        };
    }

    protected EntityTransaction getTransaction(EntityManagerEntry entityManagerEntry) {
        return new UserTransactionAdapter();
    }

    protected synchronized void beforeProceed(InvocationContext invocationContext, EntityManagerEntry entityManagerEntry, EntityTransaction transaction) {
        entityManagerEntry.getEntityManager().joinTransaction();
    }

    protected UserTransaction resolveUserTransaction() {
        return this.userTransaction;
    }

    private class UserTransactionAdapter
    implements EntityTransaction {
        public void begin() {
            if (OsgiUserTransactionStrategy.this.resolveUserTransaction() == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (OsgiUserTransactionStrategy.this.resolveUserTransaction().getStatus() == 6) {
                    OsgiUserTransactionStrategy.this.resolveUserTransaction().begin();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void commit() {
            if (OsgiUserTransactionStrategy.this.resolveUserTransaction() == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (this.isTransactionReadyToCommit()) {
                    OsgiUserTransactionStrategy.this.resolveUserTransaction().commit();
                }
            }
            catch (Exception e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void rollback() {
            if (OsgiUserTransactionStrategy.this.resolveUserTransaction() == null) {
                throw new UnsupportedOperationException("A CMT is active. This operation is only supported with BMT.");
            }
            try {
                if (this.isTransactionAllowedToRollback()) {
                    OsgiUserTransactionStrategy.this.resolveUserTransaction().rollback();
                }
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public void setRollbackOnly() {
            try {
                if (OsgiUserTransactionStrategy.this.resolveUserTransaction() != null) {
                    OsgiUserTransactionStrategy.this.resolveUserTransaction().setRollbackOnly();
                }
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public boolean getRollbackOnly() {
            try {
                return this.getTransactionStatus() == 1;
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        public boolean isActive() {
            try {
                return this.getTransactionStatus() != 6 && this.getTransactionStatus() != 5;
            }
            catch (SystemException e) {
                throw ExceptionUtils.throwAsRuntimeException((Throwable)e);
            }
        }

        protected boolean isTransactionAllowedToRollback() throws SystemException {
            return this.getTransactionStatus() != 3 && this.getTransactionStatus() != 6 && this.getTransactionStatus() != 5;
        }

        protected boolean isTransactionReadyToCommit() throws SystemException {
            return this.getTransactionStatus() == 0 || this.getTransactionStatus() == 7 || this.getTransactionStatus() == 2;
        }

        protected int getTransactionStatus() throws SystemException {
            if (OsgiUserTransactionStrategy.this.resolveUserTransaction() != null) {
                return OsgiUserTransactionStrategy.this.resolveUserTransaction().getStatus();
            }
            return 5;
        }
    }
}

