/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helper.deltaspike.configadmin.internal;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.apache.deltaspike.core.api.common.DeltaSpike;
import org.apache.deltaspike.core.spi.config.ConfigSource;
import org.apache.deltaspike.core.spi.config.ConfigSourceProvider;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.service.cm.Configuration;
import org.osgi.service.cm.ConfigurationAdmin;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigAdminTracker
implements ServiceTrackerCustomizer<ConfigurationAdmin, Object>,
ConfigSourceProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfigAdminTracker.class);
    private final Collection<ConfigurationAdmin> admins = new HashSet<ConfigurationAdmin>();
    private static ConfigAdminTracker instance;
    private transient BundleContext context;
    private transient ServiceTracker tracker;

    final Collection<ConfigurationAdmin> getAdmins() {
        return this.admins;
    }

    public static synchronized ConfigAdminTracker getInstance(BundleContext context) {
        if (instance == null) {
            instance = new ConfigAdminTracker();
        }
        ConfigAdminTracker.instance.context = context == null ? FrameworkUtil.getBundle(DeltaSpike.class).getBundleContext() : context;
        if (ConfigAdminTracker.instance.context != null && ConfigAdminTracker.instance.tracker == null) {
            ConfigAdminTracker.instance.tracker = new ServiceTracker(ConfigAdminTracker.instance.context, ConfigurationAdmin.class, (ServiceTrackerCustomizer)instance);
            instance.parseInitialContribution(ConfigAdminTracker.instance.context);
            ConfigAdminTracker.instance.tracker.open();
        }
        return instance;
    }

    public static synchronized void stop() {
        ConfigAdminTracker.instance.tracker.close();
    }

    private void parseInitialContribution(BundleContext bundleContext) {
        try {
            ServiceReference[] registeredConfigAdmins;
            for (ServiceReference adminRef : registeredConfigAdmins = bundleContext.getAllServiceReferences(ConfigurationAdmin.class.getName(), null)) {
                ConfigAdminTracker.getInstance(bundleContext).getAdmins().add((ConfigurationAdmin)bundleContext.getService(adminRef));
            }
        }
        catch (InvalidSyntaxException e) {
            log.error("Error getting servicereferences of config admin", (Throwable)e);
        }
    }

    public final Object addingService(ServiceReference<ConfigurationAdmin> reference) {
        ConfigurationAdmin admin = (ConfigurationAdmin)this.context.getService(reference);
        ConfigAdminTracker.getInstance(null).admins.add(admin);
        return admin;
    }

    public final void modifiedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
        this.removedService(reference, service);
        this.addingService(reference);
    }

    public final void removedService(ServiceReference<ConfigurationAdmin> reference, Object service) {
        ConfigurationAdmin admin = (ConfigurationAdmin)this.context.getService(reference);
        ConfigAdminTracker.getInstance(null).admins.remove(admin);
    }

    public String getProperty(String key) throws IOException, InvalidSyntaxException {
        log.info("Retreiving property key: " + key);
        for (ConfigurationAdmin admin : ConfigAdminTracker.getInstance(null).admins) {
            Configuration[] configurations = admin.listConfigurations(null);
            if (configurations == null) continue;
            for (Configuration configuration : configurations) {
                Dictionary dictionary;
                Object valObject;
                if (log.isDebugEnabled()) {
                    log.debug("parsing configuration: " + configuration.getPid());
                }
                if (!((valObject = (dictionary = configuration.getProperties()).get(key)) instanceof String)) continue;
                if (log.isTraceEnabled()) {
                    log.trace("got value: " + valObject);
                }
                return (String)valObject;
            }
        }
        return null;
    }

    public Map<String, String> getProperties() {
        HashMap ret = Maps.newHashMap();
        try {
            for (ConfigurationAdmin admin : ConfigAdminTracker.getInstance(null).admins) {
                Configuration[] configurations = admin.listConfigurations(null);
                if (configurations == null) continue;
                for (Configuration configuration : configurations) {
                    if (log.isDebugEnabled()) {
                        log.debug("parsing configuration: " + configuration.getPid());
                    }
                    Dictionary dictionary = configuration.getProperties();
                    Enumeration keys = dictionary.keys();
                    while (keys.hasMoreElements()) {
                        String key = (String)keys.nextElement();
                        Object val = dictionary.get(key);
                        if (!(val instanceof String)) continue;
                        ret.put(key, (String)val);
                    }
                }
            }
        }
        catch (IOException | InvalidSyntaxException e) {
            log.error("Error retreiving configadmin property", e);
        }
        return ret;
    }

    public List<ConfigSource> getConfigSources() {
        ArrayList ret = Lists.newArrayList();
        for (ConfigurationAdmin admin : ConfigAdminTracker.getInstance(null).admins) {
            try {
                Configuration[] configurations = admin.listConfigurations(null);
                if (configurations == null) continue;
                for (final Configuration configuration : configurations) {
                    ret.add(new ConfigSource(){

                        public boolean isScannable() {
                            return true;
                        }

                        public String getPropertyValue(String key) {
                            Dictionary dictionary = configuration.getProperties();
                            Object valObject = dictionary.get(key);
                            if (valObject instanceof String) {
                                log.trace("got value: " + valObject);
                                return (String)valObject;
                            }
                            return null;
                        }

                        public Map<String, String> getProperties() {
                            HashMap ret = Maps.newHashMap();
                            Dictionary dictionary = configuration.getProperties();
                            Enumeration keys = dictionary.keys();
                            while (keys.hasMoreElements()) {
                                String key = (String)keys.nextElement();
                                Object val = dictionary.get(key);
                                if (!(val instanceof String)) continue;
                                ret.put(key, (String)val);
                            }
                            return ret;
                        }

                        public int getOrdinal() {
                            return 0;
                        }

                        public String getConfigName() {
                            return configuration.getPid();
                        }
                    });
                }
            }
            catch (IOException | InvalidSyntaxException e) {
                log.error("Error retreiving configadmin property", e);
            }
        }
        return ret;
    }
}

