/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.helper.cdi.eager.extension;

import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collection;
import javax.enterprise.context.ApplicationScoped;
import javax.enterprise.event.Observes;
import javax.enterprise.inject.spi.AfterDeploymentValidation;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.Extension;
import javax.enterprise.inject.spi.ProcessBean;
import net.osgiliath.helper.cdi.eager.Eager;

public class EagerExtension
implements Extension {
    private final transient Collection<Bean<?>> eagerBeansList = new ArrayList();

    public <T> void collect(@Observes ProcessBean<T> event) {
        if (event.getAnnotated().isAnnotationPresent(Eager.class) && event.getAnnotated().isAnnotationPresent(ApplicationScoped.class)) {
            this.eagerBeansList.add(event.getBean());
        }
    }

    public void load(@Observes AfterDeploymentValidation event, BeanManager beanManager) {
        for (Bean<?> bean : this.eagerBeansList) {
            beanManager.getReference(bean, (Type)bean.getBeanClass(), beanManager.createCreationalContext(bean)).toString();
        }
    }
}

