/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.security;

import net.osgiliath.security.AUTHORITY;
import net.osgiliath.security.MAuthority;
import net.osgiliath.security.MUser;
import net.osgiliath.security.RepositoryUserDetailsService;
import net.osgiliath.security.SecurityService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.authentication.AuthenticationManager;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.authentication.dao.SaltSource;
import org.springframework.security.authentication.encoding.PasswordEncoder;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.AuthenticationException;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.userdetails.UserDetails;

public class LoginPasswordSecurityService
implements SecurityService {
    private static final Logger log = LoggerFactory.getLogger(LoginPasswordSecurityService.class);
    private transient AuthenticationManager authenticationManager;
    private transient PasswordEncoder passwordEncoder;
    private transient SaltSource saltSource;

    public AuthenticationManager getAuthenticationManager() {
        return this.authenticationManager;
    }

    public void setAuthenticationManager(AuthenticationManager authenticationManager) {
        this.authenticationManager = authenticationManager;
    }

    public PasswordEncoder getPasswordEncoder() {
        return this.passwordEncoder;
    }

    public void setPasswordEncoder(PasswordEncoder passwordEncoder) {
        this.passwordEncoder = passwordEncoder;
    }

    public SaltSource getSaltSource() {
        return this.saltSource;
    }

    public void setSaltSource(SaltSource saltSource) {
        this.saltSource = saltSource;
    }

    @Override
    public boolean authenticate(String username, String password) {
        UsernamePasswordAuthenticationToken aut = new UsernamePasswordAuthenticationToken((Object)username, (Object)password);
        try {
            aut = this.authenticationManager.authenticate((Authentication)aut);
            SecurityContextHolder.getContext().setAuthentication((Authentication)aut);
        }
        catch (AuthenticationException e) {
            log.error("error while authenticating", (Throwable)e);
            return false;
        }
        return aut.isAuthenticated();
    }

    @Override
    public final MUser onSubscription(MUser subscriptionMessageIn) {
        MAuthority auth = new MAuthority();
        auth.setAuthority(AUTHORITY.MEMBER);
        subscriptionMessageIn.getAuthorities().add(auth);
        String password = subscriptionMessageIn.getPassword();
        String saltedPassword = this.passwordEncoder.encodePassword(password, this.saltSource.getSalt((UserDetails)subscriptionMessageIn));
        subscriptionMessageIn.setPassword(saltedPassword);
        RepositoryUserDetailsService.getUsers().add(subscriptionMessageIn);
        return subscriptionMessageIn;
    }
}

