/*
 * Decompiled with CFR 0.152.
 */
package net.osgiliath.messaging.repository.impl;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.ObjectMessage;
import javax.jms.Session;
import net.osgiliath.messaging.HelloEntity;
import net.osgiliath.messaging.Hellos;
import net.osgiliath.messaging.repository.HelloRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jms.core.JmsOperations;
import org.springframework.jms.core.MessageCreator;

public class HelloJMSRepository
implements HelloRepository,
MessageListener {
    private static final Logger log = LoggerFactory.getLogger(HelloJMSRepository.class);
    private transient JmsOperations producer;
    private final transient List<HelloEntity> entities = new ArrayList<HelloEntity>();

    @Override
    public final Collection<? extends HelloEntity> findByHelloObjectMessage(String message) {
        ArrayList<HelloEntity> ret = new ArrayList<HelloEntity>();
        for (HelloEntity ent : this.entities) {
            if (!ent.getHelloMessage().equals(message)) continue;
            ret.add(ent);
        }
        return ret;
    }

    @Override
    public final <S extends HelloEntity> void save(S entity) {
        this.entities.add(entity);
        this.producer.send("HELLO.OUT", new MessageCreator(){

            public Message createMessage(Session arg0) throws JMSException {
                log.info("returning persisted message");
                return arg0.createObjectMessage((Serializable)HelloJMSRepository.this.findAll());
            }
        });
    }

    @Override
    public Hellos findAll() {
        Hellos hellos = new Hellos();
        hellos.setEntities(this.entities);
        return hellos;
    }

    @Override
    public void deleteAll() {
        this.entities.clear();
    }

    public void onMessage(Message message) {
        ObjectMessage objectMessage = (ObjectMessage)message;
        try {
            HelloEntity entity = (HelloEntity)objectMessage.getObject();
            log.info("received message for persistance");
            this.save(entity);
        }
        catch (JMSException e) {
            log.error("error parsing jms message", (Throwable)e);
        }
    }

    public void setProducer(JmsOperations producer) {
        this.producer = producer;
    }
}

