/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util;

import net.orbyfied.coldlib.util.Throwables;

public class Result<V> {
    static final NoValue NO_VALUE = new NoValue();
    final V value;
    final Throwable throwable;

    public static <V> Result<V> success(V value) {
        return new Result<V>(value, null);
    }

    public static <V> Result<V> failed(Throwable throwable) {
        if (throwable == null) {
            throwable = new FailedException();
        }
        return new Result<Object>(null, throwable);
    }

    Result(V value, Throwable throwable) {
        this.value = value;
        this.throwable = throwable;
    }

    public boolean isPresent() {
        return this.throwable == null;
    }

    public boolean isSuccess() {
        return this.throwable != null && this.throwable != NO_VALUE;
    }

    public Throwable error() {
        return this.throwable != NO_VALUE ? this.throwable : null;
    }

    public V orNull() {
        return this.value;
    }

    public V orElse(V def) {
        if (this.isPresent()) {
            return this.value;
        }
        return def;
    }

    public Result<V> rethrowFailed() {
        Throwable t = this.error();
        if (t != null) {
            Throwables.sneakyThrow(t);
        }
        return this;
    }

    public V orRethrow() {
        Throwable t = this.error();
        if (t != null) {
            Throwables.sneakyThrow(t);
        }
        return this.value;
    }

    public V unwrap() {
        if (this.throwable == NO_VALUE) {
            throw new AbsentValueException();
        }
        if (this.throwable != null) {
            throw new AbsentValueException("Operation failed with an exception", this.throwable);
        }
        return this.value;
    }

    public static class FailedException
    extends RuntimeException {
        @Override
        public String getMessage() {
            return "No further information";
        }
    }

    static class NoValue
    extends Throwable {
        private NoValue() {
        }
    }

    public static class AbsentValueException
    extends RuntimeException {
        public AbsentValueException() {
        }

        public AbsentValueException(String message) {
            super(message);
        }

        public AbsentValueException(String message, Throwable cause) {
            super(message, cause);
        }

        public AbsentValueException(Throwable cause) {
            super(cause);
        }
    }
}

