/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import net.orbyfied.coldlib.util.Result;
import net.orbyfied.coldlib.util.Throwables;
import net.orbyfied.j8.util.ReflectionUtil;

public interface Container<V> {
    public static <V> Container<V> finalImmutable(final V value) {
        return new Container<V>(){

            @Override
            public V get() {
                return value;
            }

            @Override
            public boolean isSet() {
                return true;
            }

            @Override
            public Container<V> set(V val) {
                throw new UnsupportedOperationException("Container is immutable");
            }

            @Override
            public Mutability mutability() {
                return Mutability.UNSUPPORTED;
            }
        };
    }

    public static <V> Container<V> futureImmutable() {
        return new Container<V>(){
            V value;
            boolean set;

            @Override
            public V get() {
                return this.value;
            }

            @Override
            public boolean isSet() {
                return this.set;
            }

            @Override
            public Container<V> set(V val) {
                if (this.set) {
                    throw new UnsupportedOperationException("This container already has a value set");
                }
                this.value = val;
                this.set = true;
                return this;
            }

            @Override
            public Mutability mutability() {
                return this.set ? Mutability.UNSUPPORTED : Mutability.MODIFY;
            }
        };
    }

    public static <V> Container<V> mutable(final V val) {
        return new Container<V>(){
            V value;
            {
                this.value = val;
            }

            @Override
            public V get() {
                return this.value;
            }

            @Override
            public boolean isSet() {
                return true;
            }

            @Override
            public Container<V> set(V val2) {
                this.value = val2;
                return this;
            }

            @Override
            public Mutability mutability() {
                return Mutability.MODIFY;
            }
        };
    }

    public static <V> Container<V> mutable() {
        return Container.mutable(null);
    }

    public static <V> Container<V> protect(final Container<V> container, final Predicate<StackTraceElement> predicate, final boolean protectNew) {
        return new Container<V>(){

            private void checkAccess() {
                StackTraceElement element = ReflectionUtil.getCallerFrame((int)2, element1 -> !element1.getClassName().startsWith("net.orbyfied.coldlib"));
                if (!predicate.test(element)) {
                    throw new SecurityException("Access to container denied");
                }
            }

            @Override
            public V get() {
                this.checkAccess();
                return container.get();
            }

            @Override
            public boolean isSet() {
                this.checkAccess();
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                this.checkAccess();
                Container ret = container.set(val);
                if (ret != container) {
                    if (protectNew) {
                        return Container.protect(ret, predicate, true);
                    }
                    return ret;
                }
                return this;
            }

            @Override
            public Mutability mutability() {
                this.checkAccess();
                return container.mutability();
            }
        };
    }

    public static <V> Container<V> forking(final Container<V> container, final BiFunction<Container<V>, V, Container<V>> forkConstructor) {
        return new Container<V>(){

            @Override
            public V get() {
                return container.get();
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                return (Container)forkConstructor.apply(container, val);
            }

            @Override
            public Mutability mutability() {
                return Mutability.FORK;
            }
        };
    }

    public static <V> Container<V> awaitable(final Container<V> container) {
        return new Container<V>(){
            final List<CompletableFuture<V>> futures = new ArrayList();

            @Override
            public V get() {
                return container.get();
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                try {
                    container.set(val);
                    for (CompletableFuture future : this.futures) {
                        future.complete(val);
                    }
                }
                catch (Throwable t) {
                    for (CompletableFuture future : this.futures) {
                        future.completeExceptionally(t);
                    }
                    Throwables.sneakyThrow(t);
                }
                return this;
            }

            @Override
            public Mutability mutability() {
                return container.mutability();
            }

            @Override
            public boolean canAwait() {
                return true;
            }

            @Override
            public CompletableFuture<V> await(boolean listen) {
                CompletableFuture future = new CompletableFuture();
                if (!listen && this.isSet()) {
                    future.complete(this.get());
                } else {
                    this.futures.add(future);
                }
                return future;
            }
        };
    }

    public static <V> Container<V> immutable(final Container<V> container) {
        return new Container<V>(){

            @Override
            public V get() {
                return container.get();
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<V> set(V val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mutability mutability() {
                return Mutability.UNSUPPORTED;
            }
        };
    }

    public static <V> Container<V> lazy(final Supplier<V> supplier) {
        return new Container<V>(){
            boolean hasCached;
            V cached;

            @Override
            public V get() {
                if (!this.hasCached) {
                    this.cached = supplier.get();
                    this.hasCached = true;
                }
                return this.cached;
            }

            @Override
            public boolean isSet() {
                return true;
            }

            @Override
            public Container<V> set(V val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mutability mutability() {
                return Mutability.UNSUPPORTED;
            }
        };
    }

    public static <V> Container<V> atomic() {
        return new Container<V>(){
            final AtomicReference<V> reference = new AtomicReference();
            boolean set;

            @Override
            public V get() {
                return this.reference.get();
            }

            @Override
            public boolean isSet() {
                return this.set;
            }

            @Override
            public Container<V> set(V val) {
                this.set = true;
                this.reference.set(val);
                return this;
            }

            @Override
            public Mutability mutability() {
                return Mutability.MODIFY;
            }
        };
    }

    public static <V, R> Container<R> mapped(final Container<V> container, final Function<V, R> function) {
        return new Container<R>(){

            @Override
            public R get() {
                return function.apply(container.get());
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<R> set(R val) {
                throw new UnsupportedOperationException();
            }

            @Override
            public Mutability mutability() {
                return Mutability.UNSUPPORTED;
            }
        };
    }

    public static <V, R> Container<R> biMapped(final Container<V> container, final Function<V, R> toFunction, final Function<R, V> fromFunction) {
        return new Container<R>(){

            @Override
            public R get() {
                return toFunction.apply(container.get());
            }

            @Override
            public boolean isSet() {
                return container.isSet();
            }

            @Override
            public Container<R> set(R val) {
                container.set(fromFunction.apply(val));
                return this;
            }

            @Override
            public Mutability mutability() {
                return container.mutability();
            }
        };
    }

    public V get();

    default public Result<V> issue() {
        try {
            return Result.success(this.get());
        }
        catch (Throwable err) {
            return Result.failed(err);
        }
    }

    default public <T> T getAs(Class<T> tClass) {
        V val = this.get();
        return (T)val;
    }

    public boolean isSet();

    public Container<V> set(V var1);

    public Mutability mutability();

    default public boolean canAwait() {
        return false;
    }

    default public CompletableFuture<V> await(boolean listen) {
        if (!listen && this.isSet()) {
            return CompletableFuture.completedFuture(this.get());
        }
        throw new UnsupportedOperationException();
    }

    default public CompletableFuture<V> await() {
        return this.await(false);
    }

    default public Container<V> cloneMutable() {
        return Container.mutable(this.get());
    }

    default public Container<V> asProtected(Predicate<StackTraceElement> predicate, boolean newProtected) {
        return Container.protect(this, predicate, newProtected);
    }

    default public Container<V> asForking(BiFunction<Container<V>, V, Container<V>> forkConstructor) {
        return Container.forking(this, forkConstructor);
    }

    default public Container<V> immutable() {
        return Container.immutable(this);
    }

    default public <R> Container<R> map(Function<V, R> function) {
        return Container.mapped(this, function);
    }

    default public <R> Container<R> biMap(Function<V, R> toFunction, Function<R, V> fromFunction) {
        return Container.biMapped(this, toFunction, fromFunction);
    }

    default public Container<V> awaitable() {
        return Container.awaitable(this);
    }

    public static enum Mutability {
        UNSUPPORTED(true, false),
        FORK(false, false),
        MODIFY(false, true);

        final boolean throwsError;
        final boolean modifiesInstance;

        private Mutability(boolean throwsError, boolean modifiesInstance) {
            this.throwsError = throwsError;
            this.modifiesInstance = modifiesInstance;
        }

        public boolean throwsError() {
            return this.throwsError;
        }

        public boolean modifiesInstance() {
            return this.modifiesInstance;
        }
    }
}

