/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.math;

public class Vector {
    int s;
    double[] data;

    public Vector(int s) {
        this.s = s;
        this.data = new double[s];
    }

    public Vector(double ... d) {
        this.s = d.length;
        this.data = d;
    }

    public int getSize() {
        return this.s;
    }

    public double[] getData() {
        return this.data;
    }

    public Vector set(int i, double d) {
        this.data[i] = d;
        return this;
    }

    public double dot(Vector vec) {
        if (vec.s != this.s) {
            throw new IllegalArgumentException("provided vector is not of same length");
        }
        double a = 0.0;
        for (int i = 0; i < this.s; ++i) {
            a += this.data[i] * vec.data[i];
        }
        return a;
    }

    public String toString() {
        StringBuilder b = new StringBuilder("(");
        for (int i = 0; i < this.s; ++i) {
            double d = this.data[i];
            if (i != 0) {
                b.append(", ");
            }
            b.append(d);
        }
        return b.append(")").toString();
    }
}

