/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.logging;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import net.orbyfied.j8.util.logging.EventLog;

public class EventLogs {
    final List<EventLog> eventLogs = new ArrayList<EventLog>();
    final Map<String, EventLog> eventLogMap = new HashMap<String, EventLog>();
    Consumer<EventLog> initializer;

    public List<EventLog> getEventLogs() {
        return this.eventLogs;
    }

    public EventLogs withInitializer(Consumer<EventLog> consumer) {
        this.initializer = consumer;
        return this;
    }

    public EventLogs forAll(Consumer<EventLog> consumer) {
        for (EventLog eventLog : this.eventLogs) {
            consumer.accept(eventLog);
        }
        return this;
    }

    public EventLogs add(EventLog log) {
        this.eventLogs.add(log);
        this.eventLogMap.put(log.getName(), log);
        return this;
    }

    public EventLog create(String name) {
        EventLog log = new EventLog(name);
        this.add(log);
        if (this.initializer != null) {
            this.initializer.accept(log);
        }
        return log;
    }

    public EventLog get(String name) {
        return this.eventLogMap.get(name);
    }

    public EventLog getOrCreate(String name) {
        EventLog log = this.get(name);
        if (log != null) {
            return log;
        }
        return this.create(name);
    }
}

