/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import java.lang.reflect.InaccessibleObjectException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;
import net.orbyfied.j8.util.builder.Builder;

public abstract class Constructor<T, B extends Builder> {
    private static final Map<Class<?>, java.lang.reflect.Constructor<?>> builderTakeConstructorCache = new HashMap();
    final Class<T> type;
    final List<Predicate<B>> predicates = new ArrayList<Predicate<B>>();

    public static <T, B extends Builder> Constructor<T, B> takeBuilder(final Class<T> tClass) {
        java.lang.reflect.Constructor<?> constructor = builderTakeConstructorCache.get(tClass);
        if (constructor == null) {
            try {
                for (java.lang.reflect.Constructor<?> c : tClass.getDeclaredConstructors()) {
                    if (c.getParameterCount() != 1 || !Builder.class.isAssignableFrom(c.getParameterTypes()[0])) continue;
                    constructor = c;
                    break;
                }
                if (constructor == null) {
                    System.err.println("Could not find builder-take constructor for type " + tClass.getName());
                    return null;
                }
                constructor.setAccessible(true);
            }
            catch (InaccessibleObjectException e) {
                System.err.println("Could not access builder-take constructor for type " + tClass.getName());
                e.printStackTrace();
                return null;
            }
            catch (Exception e) {
                System.err.println("Error finding builder-take constructor for type " + tClass.getName());
                e.printStackTrace();
                return null;
            }
        }
        builderTakeConstructorCache.put(tClass, constructor);
        final java.lang.reflect.Constructor<?> fConstructor = constructor;
        return new Constructor<T, B>(tClass){

            @Override
            public T construct(B builder) {
                try {
                    return fConstructor.newInstance(builder);
                }
                catch (Exception e) {
                    throw new RuntimeException("Failed to create instance of type " + tClass.getName() + " using builder-take constructor.", e);
                }
            }
        };
    }

    public Constructor(Class<T> type) {
        this.type = type;
    }

    public abstract T construct(B var1);

    @SafeVarargs
    public final Constructor<T, B> onlyIf(Predicate<B> ... p) {
        this.predicates.addAll(Arrays.asList(p));
        return this;
    }

    public boolean test(B builder) {
        for (Predicate<B> predicate : this.predicates) {
            if (predicate.test(builder)) continue;
            return false;
        }
        return true;
    }
}

