/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util.builder;

import net.orbyfied.j8.util.builder.BuilderTemplate;
import net.orbyfied.j8.util.builder.Constructor;
import net.orbyfied.j8.util.builder.Values;

public class Builder<T, S extends Builder> {
    final BuilderTemplate<T, S> template;
    final Class<T> type;
    final Values parameters;
    final S self = this;

    public static <V> Raw<V> raw(BuilderTemplate<V, Raw<V>> template) {
        return new Raw<V>(template);
    }

    public Builder(BuilderTemplate<T, S> template) {
        this.template = template;
        this.type = template.type();
        this.parameters = template.parameters().blank();
    }

    public T build() {
        Constructor<T, S> constructor = this.template.findConstructor(this.self);
        T t = constructor.construct(this.self);
        return t;
    }

    public S set(String name, Object val) {
        this.parameters.set(name, val);
        return this.self;
    }

    public S unset(String name) {
        this.parameters.unset(name);
        return this.self;
    }

    public <V> V get(String name) {
        return (V)this.parameters.get(name);
    }

    public S ignore(String name) {
        this.parameters.mark("ignored", this.parameters.property(name), true);
        return this.self;
    }

    public static class Raw<T>
    extends Builder<T, Raw<T>> {
        public Raw(BuilderTemplate<T, Raw<T>> template) {
            super(template);
        }
    }
}

