/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.j8.util;

import java.io.PrintStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class ReflectionUtil {
    public static Class<?> getCallerClass(int off) {
        try {
            return Class.forName(ReflectionUtil.getCallerFrame(off).getClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    public static StackTraceElement getCallerFrame(int off) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elem = e.getStackTrace();
            return elem[1 + off];
        }
    }

    public static StackTraceElement getCallerFrame(int off, Predicate<StackTraceElement> pred) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elems = e.getStackTrace();
            int l = elems.length;
            for (int i = 1 + off; i < l; ++i) {
                StackTraceElement element = elems[i];
                if (!pred.test(element)) continue;
                return element;
            }
            return elems[elems.length - 1];
        }
    }

    public static void walkParents(Class<?> klass, Predicate<Class<?>> pred, Consumer<Class<?>> consumer) {
        ReflectionUtil.walkParents(klass, pred, (Integer depth, Class<?> c) -> consumer.accept((Class<?>)c));
    }

    public static void walkParents(Class<?> klass, Predicate<Class<?>> pred, BiConsumer<Integer, Class<?>> consumer) {
        ReflectionUtil.internalWalkParents(klass, pred, consumer, 0);
    }

    public static void internalWalkParents(Class<?> klass, Predicate<Class<?>> pred, BiConsumer<Integer, Class<?>> consumer, int depth) {
        try {
            if (pred != null && !pred.test(klass)) {
                return;
            }
            consumer.accept(depth, klass);
            if (klass.getSuperclass() != Object.class && klass.getSuperclass() != null) {
                ReflectionUtil.internalWalkParents(klass.getSuperclass(), pred, consumer, depth + 1);
            }
            for (Class<?> c : klass.getInterfaces()) {
                ReflectionUtil.internalWalkParents(c, pred, consumer, depth + 1);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void printParentTree(PrintStream out, Class<?> klass) {
        ReflectionUtil.walkParents(klass, null, (Integer d, Class<?> c) -> out.println("@ depth " + d + ": " + "  ".repeat((int)d) + "|- " + c));
    }

    public static void printParentTree(Class<?> klass) {
        ReflectionUtil.printParentTree(System.out, klass);
    }

    public static void printCallTree(PrintStream out, int off) {
        try {
            throw new Exception();
        }
        catch (Exception e) {
            StackTraceElement[] elements = e.getStackTrace();
            out.println("+ CALLED: " + elements[1 + off]);
            for (int i = 2 + off; i < elements.length; ++i) {
                out.println("| " + elements[i]);
            }
            return;
        }
    }

    public static void printCallTree() {
        ReflectionUtil.printCallTree(System.out, 1);
    }

    public static void printCallTree(int off) {
        ReflectionUtil.printCallTree(System.out, off + 1);
    }

    public static void printCallTree(PrintStream out) {
        ReflectionUtil.printCallTree(out, 1);
    }

    public static Class<?> getClassSafe(String name) {
        try {
            return Class.forName(name);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Field getDeclaredFieldSafe(Class<?> klass, String name) {
        Objects.requireNonNull(klass);
        try {
            Field f = klass.getDeclaredField(name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Method getDeclaredMethodSafe(Class<?> klass, String name, Class ... argTypes) {
        Objects.requireNonNull(klass);
        try {
            Method m = klass.getDeclaredMethod(name, argTypes);
            m.setAccessible(true);
            return m;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static Constructor<?> getDeclaredConstructorSafe(Class<?> klass, Class ... argTypes) {
        Objects.requireNonNull(klass);
        try {
            Constructor<?> c = klass.getDeclaredConstructor(argTypes);
            c.setAccessible(true);
            return c;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T queryFieldSafe(Object on, Field f) {
        try {
            return (T)f.get(on);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static void setFieldSafe(Object on, Field f, Object val) {
        try {
            f.set(on, val);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static <T> T invokeSafe(Method m, Object on, Object ... args) {
        try {
            return (T)m.invoke(on, args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public static <T> T newInstance(Constructor<?> c, Object ... args) {
        try {
            return (T)c.newInstance(args);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }
}

