/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util.logic;

import java.util.BitSet;

public interface BitFlag {
    public static BitFlag at(int offset) {
        return () -> offset;
    }

    public static BitFlag all() {
        return new BitFlag(){

            @Override
            public int getBitOffset() {
                return -1;
            }

            @Override
            public long getBitMask() {
                return -1L;
            }

            @Override
            public BitSet set(BitSet set, boolean value) {
                set.set(0, set.length(), value);
                return set;
            }
        };
    }

    public int getBitOffset();

    default public long getBitMask() {
        return 1L >> this.getBitOffset();
    }

    default public BitSet set(BitSet set, boolean value) {
        set.set(this.getBitOffset(), value);
        return set;
    }

    default public int set(int i, boolean value) {
        if (value) {
            return i | (int)this.getBitMask();
        }
        return i & ~((int)this.getBitMask());
    }

    default public long set(long i, boolean value) {
        if (value) {
            return i | this.getBitMask();
        }
        return i & (this.getBitMask() ^ 0xFFFFFFFFFFFFFFFFL);
    }
}

