/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util.functional;

import java.util.function.Supplier;
import net.orbyfied.coldlib.util.Container;
import net.orbyfied.coldlib.util.Result;
import net.orbyfied.coldlib.util.Throwables;

@FunctionalInterface
public interface ThrowingSupplier<T>
extends Supplier<T> {
    public static <T> ThrowingSupplier<T> of(ThrowingSupplier<T> supplier) {
        return supplier;
    }

    public static <T> ThrowingSupplier<T> constant(T value) {
        return () -> value;
    }

    public T issue() throws Throwable;

    @Override
    default public T get() {
        try {
            return this.issue();
        }
        catch (Throwable t) {
            Throwables.sneakyThrow(t);
            return null;
        }
    }

    default public T tryOrNull() {
        try {
            return this.issue();
        }
        catch (Throwable t) {
            return null;
        }
    }

    default public Result<T> attempt() {
        try {
            return Result.success(this.issue());
        }
        catch (Throwable t) {
            return Result.failed(t);
        }
    }

    default public Container<T> asContainer() {
        return Container.lazy(this);
    }
}

