/*
 * Decompiled with CFR 0.152.
 */
package net.orbyfied.coldlib.util;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;

public class Assembly<I, T, O> {
    final Class<I> intermediateType;
    final Class<T> resultType;
    final Class<O> optionsType;
    protected final Supplier<O> defaultOptionProvider;
    protected final InstanceFactory<I, O> instanceFactory;
    protected final Line<I, O> intermediateLine;
    protected final Function<I, T> finalizer;
    protected final Line<T, O> resultLine;

    Assembly(Class<I> intermediateType, Class<T> resultType, Class<O> optionsType, Supplier<O> defaultOptionProvider, InstanceFactory<I, O> instanceFactory, Line<I, O> intermediateLine, Function<I, T> finalizer, Line<T, O> resultLine) {
        this.intermediateType = intermediateType;
        this.resultType = resultType;
        this.optionsType = optionsType;
        Objects.requireNonNull(instanceFactory, "Intermediate instance factory can not be null");
        this.defaultOptionProvider = defaultOptionProvider;
        this.instanceFactory = instanceFactory;
        this.intermediateLine = intermediateLine;
        this.resultLine = resultLine;
        this.finalizer = Objects.requireNonNullElse(finalizer, i -> i);
    }

    protected O getDefaultOptions() {
        return this.defaultOptionProvider == null ? null : (O)this.defaultOptionProvider.get();
    }

    public T build() {
        return this.build(this.getDefaultOptions());
    }

    public T build(O options) {
        I intermediate = this.instanceFactory.create(options);
        if (this.intermediateLine != null) {
            intermediate = this.intermediateLine.push(intermediate, options);
        }
        T result = this.finalizer.apply(intermediate);
        if (this.resultLine != null) {
            result = this.resultLine.push(result, options);
        }
        return result;
    }

    public Builder<I, T, O> toBuilder() {
        Builder<I, T, O> builder = Assembly.builder(this.intermediateType, this.resultType, this.optionsType);
        builder.defaultOptionsProvider = this.defaultOptionProvider;
        builder.instanceFactory = this.instanceFactory;
        builder.intermediateTransformers = new ArrayList(this.intermediateLine.transformers);
        builder.finalizer = this.finalizer;
        builder.resultTransformers = new ArrayList(this.resultLine.transformers);
        return builder;
    }

    public Class<I> getIntermediateType() {
        return this.intermediateType;
    }

    public Class<T> getResultType() {
        return this.resultType;
    }

    public Class<O> getOptionsType() {
        return this.optionsType;
    }

    public static <I, T, O> Builder<I, T, O> builder(Class<I> iClass, Class<T> tClass, Class<O> oClass) {
        Objects.requireNonNull(iClass);
        Objects.requireNonNull(tClass);
        return new Builder<I, T, O>(iClass, tClass, oClass);
    }

    @FunctionalInterface
    public static interface InstanceFactory<T, O> {
        public T create(O var1);
    }

    public static class Line<T, O> {
        protected List<Transformer<T, O>> transformers;

        public Line(List<Transformer<T, O>> transformers) {
            if (transformers == null) {
                transformers = new ArrayList<Transformer<T, O>>(0);
            }
            this.transformers = transformers;
        }

        public T push(T in, O options) {
            T current = in;
            int l = this.transformers.size();
            for (int i = 0; i < l; ++i) {
                Transformer<T, O> transformer = this.transformers.get(i);
                current = transformer.transform(current, options);
            }
            return current;
        }
    }

    public static class Builder<I, T, O> {
        final Class<I> intermediateType;
        final Class<T> resultType;
        final Class<O> optionsType;
        Supplier<O> defaultOptionsProvider;
        Function<I, T> finalizer;
        InstanceFactory<I, O> instanceFactory;
        List<Transformer<I, O>> intermediateTransformers = new ArrayList<Transformer<I, O>>();
        List<Transformer<T, O>> resultTransformers = new ArrayList<Transformer<T, O>>();

        Builder(Class<I> intermediateType, Class<T> resultType, Class<O> optionsType) {
            Objects.requireNonNull(intermediateType, "Intermediate type can not be null");
            Objects.requireNonNull(resultType, "Result type can not be null");
            if (optionsType == null) {
                optionsType = Object.class;
            }
            this.intermediateType = intermediateType;
            this.resultType = resultType;
            this.optionsType = optionsType;
        }

        public Assembly<I, T, O> build() {
            return new Assembly<I, T, O>(this.intermediateType, this.resultType, this.optionsType, this.defaultOptionsProvider, this.instanceFactory, new Line(this.intermediateTransformers), this.finalizer, new Line<T, O>(this.resultTransformers));
        }

        private <V> Transformer<V, O> makeTransformer(BiConsumer<V, O> consumer) {
            return (in, options) -> {
                consumer.accept(in, options);
                return in;
            };
        }

        public Supplier<O> getDefaultOptionsProvider() {
            return this.defaultOptionsProvider;
        }

        public Builder<I, T, O> setDefaultOptionsProvider(Supplier<O> defaultOptionsProvider) {
            this.defaultOptionsProvider = defaultOptionsProvider;
            return this;
        }

        public Builder<I, T, O> setDefaultOptions(O options) {
            return this.setDefaultOptionsProvider(() -> options);
        }

        public Function<I, T> getFinalizer() {
            return this.finalizer;
        }

        public Builder<I, T, O> setFinalizer(Function<I, T> finalizer) {
            this.finalizer = finalizer;
            return this;
        }

        public InstanceFactory<I, O> getInstanceFactory() {
            return this.instanceFactory;
        }

        public Builder<I, T, O> setInstanceFactory(InstanceFactory<I, O> instanceFactory) {
            this.instanceFactory = instanceFactory;
            return this;
        }

        public List<Transformer<I, O>> getIntermediateTransformers() {
            return this.intermediateTransformers;
        }

        public Builder<I, T, O> setIntermediateTransformers(List<Transformer<I, O>> intermediateTransformers) {
            this.intermediateTransformers = intermediateTransformers;
            return this;
        }

        public Builder<I, T, O> addIntermediateTransformer(Transformer<I, O> transformer) {
            this.intermediateTransformers.add(transformer);
            return this;
        }

        public Builder<I, T, O> addIntermediateConsumer(BiConsumer<I, O> transformer) {
            return this.addIntermediateTransformer(this.makeTransformer(transformer));
        }

        public List<Transformer<T, O>> getResultTransformers() {
            return this.resultTransformers;
        }

        public Builder<I, T, O> setResultTransformers(List<Transformer<T, O>> resultTransformers) {
            this.resultTransformers = resultTransformers;
            return this;
        }

        public Builder<I, T, O> addResultTransformer(Transformer<T, O> transformer) {
            this.resultTransformers.add(transformer);
            return this;
        }

        public Builder<I, T, O> addResultConsumer(BiConsumer<T, O> transformer) {
            return this.addResultTransformer(this.makeTransformer(transformer));
        }
    }

    public static interface Transformer<T, O> {
        public T transform(T var1, O var2);
    }
}

